/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.effect;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourARGB;
import codechicken.lib.math.MathHelper;
import codechicken.lib.render.shader.ShaderProgram;
import com.brandon3055.brandonscore.client.particle.BCParticle;
import com.brandon3055.brandonscore.client.particle.IGLFXHandler;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.render.shaders.DEShaders;
import com.brandon3055.draconicevolution.helpers.ResourceHelperDE;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ReactorBeamFX
extends BCParticle {
    protected int ticksTillDeath = 0;
    protected float fxState;
    private float powerState;
    private TileReactorCore tile;
    private boolean isInjectorEffect;
    private final EnumFacing facing;
    private double dist;
    private static Colour fieldBeamColour = new ColourARGB(45311);
    private static Colour extractBeamColour = new ColourARGB(0xFF6600);
    private static Colour energyBeamColour = new ColourARGB(0xFF0000);
    private int boltSeed = -1;
    public static ShaderProgram beam_E;
    public static ShaderProgram beam_O;
    public static ShaderProgram beam_I;
    public static final IGLFXHandler FX_HANDLER;

    public ReactorBeamFX(World worldIn, Vec3D pos, EnumFacing facing, TileReactorCore tile, boolean isInjectorEffect) {
        super(worldIn, pos);
        this.facing = facing;
        this.tile = tile;
        this.isInjectorEffect = isInjectorEffect;
        this.dist = Utils.getDistanceAtoB((Vec3D)pos, (Vec3D)Vec3D.getCenter((BlockPos)tile.func_174877_v()));
        this.field_187136_p.setSeed(worldIn.field_73012_v.nextLong());
    }

    public boolean isRawGLParticle() {
        return true;
    }

    public void updateFX(float fxState, float powerState) {
        this.fxState = fxState;
        if (powerState != this.powerState) {
            ReactorBeamFX.fieldBeamColour.r = (byte)(this.powerState * 255.0f);
            ReactorBeamFX.fieldBeamColour.g = (byte)((1.0f - this.powerState) * 176.0f);
            ReactorBeamFX.fieldBeamColour.b = (byte)((1.0f - this.powerState) * 255.0f);
        }
        this.powerState = powerState;
        this.ticksTillDeath = 4;
    }

    public void func_189213_a() {
        if (this.ticksTillDeath-- <= 0) {
            this.func_187112_i();
        }
    }

    public void func_180434_a(BufferBuilder buffer, Entity entity, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        if (this.tile.roller != null) {
            return;
        }
        Vec3D pos1 = new Vec3D(this.field_187126_f - field_70556_an, this.field_187127_g - field_70554_ao, this.field_187128_h - field_70555_ap).offset(this.facing, -0.35);
        double texOffset = (double)((float)ClientEventHandler.elapsedTicks + partialTicks) / -150.0;
        double coreSize = this.tile.getCoreDiameter() / 2.3;
        if (!DEShaders.useShaders() || !DEConfig.useReactorBeamShaders) {
            this.renderWithoutShaders(buffer, pos1, coreSize, texOffset);
            return;
        }
        float animation = ((float)ClientEventHandler.elapsedTicks + partialTicks) * 0.02f;
        texOffset = 0.0;
        if (this.isInjectorEffect) {
            if (beam_E == null) {
                beam_E = new ShaderProgram();
                beam_E.attachShader(DEShaders.reactorBeamE);
            }
            beam_E.useShader(cache -> {
                cache.glUniform1F("time", animation);
                cache.glUniform1F("fade", 1.0f);
                cache.glUniform1F("power", this.fxState);
                cache.glUniform1F("startup", this.fxState);
            });
            Vec3D pos2 = pos1.copy().offset(this.facing, 0.6);
            this.renderShaderBeam(buffer, pos1, 0.1f, 0.1f, 0.6, 0.0, 0.0, true, energyBeamColour);
            beam_E.useShader(cache -> cache.glUniform1F("fade", 0.0f));
            this.renderShaderBeam(buffer, pos2, 0.1f, coreSize / 1.5, this.dist - coreSize * 1.3, 0.0, 0.0, false, energyBeamColour);
            beam_E.releaseShader();
        } else {
            Vec3D pos2 = pos1.copy().offset(this.facing, 0.8);
            if (beam_O == null) {
                beam_O = new ShaderProgram();
                beam_O.attachShader(DEShaders.reactorBeamO);
            }
            beam_O.useShader(cache -> {
                cache.glUniform1F("time", animation);
                cache.glUniform1F("fade", 1.0f);
                cache.glUniform1F("power", (float)this.tile.animExtractState.value);
                cache.glUniform1F("startup", (float)this.tile.animExtractState.value);
            });
            this.renderShaderBeam(buffer, pos1, 0.263f, 0.263f, 0.8, texOffset, 0.0, true, extractBeamColour);
            beam_O.useShader(cache -> cache.glUniform1F("fade", 0.0f));
            this.renderShaderBeam(buffer, pos2, 0.263f, coreSize / 2.0, this.dist - coreSize * 1.3, texOffset, 0.0, false, extractBeamColour);
            if (beam_I == null) {
                beam_I = new ShaderProgram();
                beam_I.attachShader(DEShaders.reactorBeamI);
            }
            beam_I.useShader(cache -> {
                cache.glUniform1F("time", animation);
                cache.glUniform1F("fade", 1.0f);
                cache.glUniform1F("power", this.fxState);
                cache.glUniform1F("startup", this.fxState);
            });
            this.renderShaderBeam(buffer, pos1, 0.355, 0.355, 0.8, texOffset, 0.0, true, fieldBeamColour);
            beam_I.useShader(cache -> cache.glUniform1F("fade", 0.0f));
            this.renderShaderBeam(buffer, pos2, 0.355, coreSize, this.dist - coreSize, texOffset, 0.0, false, fieldBeamColour);
            beam_I.releaseShader();
        }
    }

    public void renderWithoutShaders(BufferBuilder buffer, Vec3D pos1, double coreSize, double texOffset) {
        if (this.isInjectorEffect) {
            ResourceHelperDE.bindTexture("textures/particle/reactor_energy_beam.png");
            Vec3D pos2 = pos1.copy().offset(this.facing, 0.6);
            this.renderBeam(buffer, pos1, 0.1, 0.1, 0.6, texOffset, texOffset * 15.0, true, energyBeamColour);
            this.renderBeam(buffer, pos2, 0.1, coreSize / 1.5, this.dist - coreSize * 1.3, texOffset + 0.1, texOffset * 15.0, false, energyBeamColour);
        } else {
            Vec3D pos2 = pos1.copy().offset(this.facing, 0.8);
            this.renderBeam(buffer, pos1, 0.355, 0.355, 0.8, texOffset, 0.0, true, fieldBeamColour);
            this.renderBeam(buffer, pos2, 0.355, coreSize, this.dist - coreSize, texOffset + 0.1, 0.0, false, fieldBeamColour);
            this.renderBeam(buffer, pos1, 0.263f, 0.263f, 0.8, -texOffset, 0.0, true, extractBeamColour);
            this.renderBeam(buffer, pos2, 0.263f, coreSize / 2.0, this.dist - coreSize * 1.3, -texOffset + 0.1, 0.0, false, extractBeamColour);
        }
    }

    public void renderBeam(BufferBuilder buffer, Vec3D pos, double widthStart, double widthEnd, double length, double beamAnimation, double beamRotation, boolean fadeReverse, Colour colour) {
        buffer.func_181668_a(5, DefaultVertexFormats.field_181709_i);
        double sides = 16.0;
        float r = (float)(colour.r & 0xFF) / 255.0f;
        float g = (float)(colour.g & 0xFF) / 255.0f;
        float b = (float)(colour.b & 0xFF) / 255.0f;
        int i = 0;
        while ((double)i < sides) {
            double sin = MathHelper.sin((double)((double)i % sides * Math.PI * 2.13325 / sides + beamRotation));
            double cos = MathHelper.cos((double)((double)i % sides * Math.PI * 2.13325 / sides + beamRotation));
            double texX = (double)i % sides * 1.0 / sides;
            Vec3D point = pos.copy().radialOffset(this.facing.func_176740_k(), sin, cos, widthStart);
            buffer.func_181662_b(point.x, point.y, point.z).func_187315_a(texX, beamAnimation).func_181666_a(r, g, b, fadeReverse ? 0.0f : this.fxState).func_181675_d();
            point.offset(this.facing, length);
            point.radialOffset(this.facing.func_176740_k(), sin, cos, widthEnd - widthStart);
            buffer.func_181662_b(point.x, point.y, point.z).func_187315_a(texX, 0.1 + beamAnimation).func_181666_a(r, g, b, fadeReverse ? this.fxState : 0.0f).func_181675_d();
            ++i;
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    public void renderShaderBeam(BufferBuilder buffer, Vec3D pos, double widthStart, double widthEnd, double length, double beamAnimation, double beamRotation, boolean fadeReverse, Colour colour) {
        buffer.func_181668_a(5, DefaultVertexFormats.field_181709_i);
        double sides = 16.0;
        int i = 0;
        while ((double)i < sides) {
            double sin = MathHelper.sin((double)((double)i % sides * Math.PI * 2.13325 / sides + beamRotation));
            double cos = MathHelper.cos((double)((double)i % sides * Math.PI * 2.13325 / sides + beamRotation));
            double s = sides - 0.99999999;
            double texX = (double)i % s * (1.0 / s);
            Vec3D point = pos.copy().radialOffset(this.facing.func_176740_k(), sin, cos, widthStart);
            buffer.func_181662_b(point.x, point.y, point.z).func_187315_a(texX, (fadeReverse ? 0.1 : 1.0) + beamAnimation).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            point.offset(this.facing, length);
            point.radialOffset(this.facing.func_176740_k(), sin, cos, widthEnd - widthStart);
            buffer.func_181662_b(point.x, point.y, point.z).func_187315_a(texX, beamAnimation).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            ++i;
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    public IGLFXHandler getFXHandler() {
        return FX_HANDLER;
    }

    static {
        FX_HANDLER = new IGLFXHandler(){

            public void preDraw(int layer, BufferBuilder vertexbuffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
                ResourceHelperDE.bindTexture("textures/particle/reactor_beam.png");
                GlStateManager.func_179129_p();
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179092_a((int)516, (float)0.0f);
                if (!DEShaders.useShaders() || !DEConfig.useReactorBeamShaders) {
                    GlStateManager.func_187403_b((int)3553, (int)10242, (float)10497.0f);
                    GlStateManager.func_187403_b((int)3553, (int)10243, (float)10497.0f);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                }
            }

            public void postDraw(int layer, BufferBuilder vertexbuffer, Tessellator tessellator) {
                GlStateManager.func_179092_a((int)516, (float)0.1f);
                GlStateManager.func_179089_o();
                if (!DEShaders.useShaders() || !DEConfig.useReactorBeamShaders) {
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                }
            }
        };
    }
}

