/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import appeng.api.movable.IMovableTile;
import codechicken.lib.packet.PacketCustom;
import com.brandon3055.brandonscore.blocks.TileInventoryBase;
import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.brandonscore.lib.PairKV;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.Vec3I;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedByte;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.lib.datamanager.ManagedVec3I;
import com.brandon3055.brandonscore.utils.FacingUtils;
import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.brandonscore.utils.Teleporter;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.api.ICrystalLink;
import com.brandon3055.draconicevolution.api.IENetEffectTile;
import com.brandon3055.draconicevolution.api.ITeleportEndPoint;
import com.brandon3055.draconicevolution.blocks.DislocatorReceptacle;
import com.brandon3055.draconicevolution.blocks.Portal;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandler;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandlerClient;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandlerServer;
import com.brandon3055.draconicevolution.blocks.tileentity.TilePortal;
import com.brandon3055.draconicevolution.client.render.effect.CrystalGLFXBase;
import com.brandon3055.draconicevolution.handlers.DEEventHandler;
import com.brandon3055.draconicevolution.handlers.DislocatorLinkHandler;
import com.brandon3055.draconicevolution.integration.funkylocomotion.IMovableStructure;
import com.brandon3055.draconicevolution.items.tools.Dislocator;
import com.brandon3055.draconicevolution.lib.DESoundHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(modid="appliedenergistics2", iface="appeng.api.movable.IMovableTile")
public class TileDislocatorReceptacle
extends TileInventoryBase
implements ITickable,
ITeleportEndPoint,
IMovableStructure,
ICrystalLink,
IENetEffectTile,
IMovableTile {
    public final ManagedBool NEW_OFFSETS = (ManagedBool)this.register("NEW_OFFSETS", (IManagedData)new ManagedBool(false)).saveToTile().finish();
    public final ManagedBool ACTIVE = (ManagedBool)this.register("ACTIVE", (IManagedData)new ManagedBool(false)).saveToTile().syncViaTile().trigerUpdate().finish();
    public final ManagedBool CAMO = (ManagedBool)this.register("CAMO", (IManagedData)new ManagedBool(false)).saveToTile().syncViaTile().trigerUpdate().finish();
    public final ManagedBool LT_REDSTONE = (ManagedBool)this.register("LT_REDSTONE", (IManagedData)new ManagedBool(false)).saveToTile().syncViaTile().trigerUpdate().finish();
    public final ManagedVec3I SPAWN_POS = (ManagedVec3I)this.register("SPAWN_POS", (IManagedData)new ManagedVec3I(new Vec3I(0, -999, 0))).saveToTile().syncViaTile().finish();
    public final ManagedEnum<EnumFacing.Axis> ACTIVE_AXIS = (ManagedEnum)this.register("ACTIVE_AXIS", (IManagedData)new ManagedEnum((Enum)EnumFacing.Axis.X)).syncViaTile().saveToTile().finish();
    public final ManagedBool IS_BOUND = (ManagedBool)this.register("IS_BOUND", (IManagedData)new ManagedBool(false)).saveToTile().syncViaTile().finish();
    public final ManagedVec3I LINKED_CRYSTAL = (ManagedVec3I)this.register("CRYSTAL_POS", (IManagedData)new ManagedVec3I(new Vec3I(0, -999, 0))).saveToTile().syncViaTile().finish();
    public final ManagedByte REMOTE_CRYSTAL_TIER = (ManagedByte)this.register("CRYSTAL_POS_TIER", (IManagedData)new ManagedByte(0)).saveToTile().syncViaTile().finish();
    public final ManagedByte LINKED_FLOW_RATE = (ManagedByte)this.register("LINKED_FLOW_RATE", (IManagedData)new ManagedByte(0)).syncViaTile().finish();
    public final ManagedVec3I CRYSTAL_LINK_POS = (ManagedVec3I)this.register("CRYSTAL_LINK_POS", (IManagedData)new ManagedVec3I(new Vec3I(0, -999, 0))).saveToTile().syncViaTile().finish();
    public int hiddenTime = 0;
    public boolean igniting = false;
    public boolean frameMoving = false;
    private List<Entity> teleportQ = new ArrayList<Entity>();
    private Map<Integer, Integer> coolDownMap = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> arrivalsMap = new HashMap<Integer, Integer>();
    private BlockPos remotePosCache = null;
    private int remoteDimCache = 0;
    private int invalidLinkTime = 0;
    protected ENetFXHandler fxHandler;
    boolean hashCached = false;
    int hashID = 0;

    public TileDislocatorReceptacle() {
        this.setInventorySize(1);
        this.setShouldRefreshOnBlockChange();
        this.fxHandler = DraconicEvolution.proxy.createENetFXHandler(this);
    }

    public void func_73660_a() {
        super.update();
        this.updateHidden(false);
        this.updateCrystalLogic();
        if (this.field_145850_b.field_72995_K && !this.ACTIVE.value) {
            this.hiddenTime = 5;
        }
        if (!this.field_145850_b.field_72995_K && !this.NEW_OFFSETS.value && this.ACTIVE.value) {
            this.deactivate();
            this.attemptIgnition();
            this.NEW_OFFSETS.value = true;
        }
        if (this.frameMoving) {
            if (this.ACTIVE.value) {
                this.finishMove(this.field_174879_c, new HashSet<BlockPos>());
            }
            this.frameMoving = false;
            this.checkIn();
        }
        for (Entity entity : this.teleportQ) {
            ItemStack stack = this.func_70301_a(0);
            if (!(stack.func_77973_b() instanceof Dislocator)) {
                this.deactivate();
                return;
            }
            Teleporter.TeleportLocation location = ((Dislocator)stack.func_77973_b()).getLocation(stack, this.field_145850_b);
            if (DEFeatures.dislocatorBound.isValid(stack) && location != null) {
                location.setYaw(entity.field_70177_z);
                location.setPitch(entity.field_70125_A);
            }
            if (location == null) {
                if (!DEFeatures.dislocatorBound.isValid(stack)) {
                    this.deactivate();
                } else if (entity instanceof EntityPlayer) {
                    if (DEFeatures.dislocatorBound.isPlayer(stack)) {
                        ChatHelper.translate((ICommandSender)entity, (String)"info.de.bound_dislocator.cant_find_player", (TextFormatting)TextFormatting.RED, (Object[])new Object[0]);
                    } else {
                        ChatHelper.translate((ICommandSender)entity, (String)"info.de.bound_dislocator.cant_find_target", (TextFormatting)TextFormatting.RED, (Object[])new Object[0]);
                    }
                }
                this.teleportQ.clear();
                return;
            }
            DEFeatures.dislocatorBound.notifyArriving(stack, this.field_145850_b, entity);
            DESoundHandler.playSoundFromServer(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, DESoundHandler.portal, SoundCategory.PLAYERS, 0.1f, entity.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f, false, 32.0);
            location.teleport(entity);
            DESoundHandler.playSoundFromServer(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, DESoundHandler.portal, SoundCategory.PLAYERS, 0.1f, entity.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f, false, 32.0);
        }
        try {
            ArrayList<Integer> toRemove = new ArrayList<Integer>();
            for (Integer key : this.coolDownMap.keySet()) {
                if (this.coolDownMap.get(key) > 0) {
                    this.coolDownMap.put(key, this.coolDownMap.get(key) - 1);
                    continue;
                }
                toRemove.add(key);
            }
            for (Integer i : toRemove) {
                this.coolDownMap.remove(i);
            }
            toRemove.clear();
            toRemove = new ArrayList();
            for (Integer key : this.arrivalsMap.keySet()) {
                if (this.arrivalsMap.get(key) > 0) {
                    this.arrivalsMap.put(key, this.arrivalsMap.get(key) - 1);
                    continue;
                }
                toRemove.add(key);
            }
            for (Integer i : toRemove) {
                this.arrivalsMap.remove(i);
            }
            toRemove.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.teleportQ.clear();
    }

    private void updateCrystalLogic() {
        boolean boundCrystals;
        this.fxHandler.update();
        boolean bl = boundCrystals = this.ACTIVE.value && this.IS_BOUND.value && this.LINKED_CRYSTAL.vec.y != -999;
        if (this.field_145850_b.field_72995_K && boundCrystals && this.REMOTE_CRYSTAL_TIER.detectChanges()) {
            this.fxHandler.reloadConnections();
        }
        if (!this.field_145850_b.field_72995_K && boundCrystals) {
            if (DEEventHandler.serverTicks % 10 == 0) {
                TileDislocatorReceptacle remoteTile = this.getRemoteReceptacle();
                ICrystalLink remote = this.getRemoteCrystal();
                if (remoteTile != null && remote instanceof IENetEffectTile) {
                    int i = remote.getLinks().indexOf(remoteTile.func_174877_v());
                    LinkedList<Byte> rates = ((IENetEffectTile)remote).getFlowRates();
                    this.LINKED_FLOW_RATE.value = i >= 0 && i < rates.size() ? (Byte)rates.get(i) : (byte)0;
                } else {
                    this.LINKED_FLOW_RATE.value = 0;
                }
            }
            if (this.LINKED_FLOW_RATE.value != 0 && DEEventHandler.serverTicks % 100 == 0) {
                this.dataManager.forceSync((IManagedData)this.LINKED_FLOW_RATE);
            }
        } else if (!this.field_145850_b.field_72995_K) {
            this.LINKED_FLOW_RATE.value = 0;
        }
    }

    public void setHidden() {
        boolean firstSet = this.hiddenTime == 0;
        this.hiddenTime = 30;
        if (firstSet) {
            this.updateHidden(true);
        }
    }

    private void updateHidden(boolean setHidden) {
        if (this.field_145850_b.field_72995_K && this.hiddenTime > 0) {
            --this.hiddenTime;
            if (this.hiddenTime == 0 || setHidden) {
                long time = System.nanoTime();
                for (BlockPos checkPos : BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177982_a(-1, -1, -1), (BlockPos)this.field_174879_c.func_177982_a(1, 1, 1))) {
                    BlockPos spawn;
                    TileEntity tile = this.field_145850_b.func_175625_s(checkPos);
                    if (!(tile instanceof TilePortal)) continue;
                    BlockPos blockPos = spawn = this.SPAWN_POS.vec.y == -999 ? this.field_174879_c : this.getSpawnPos();
                    TilePortal tPortal = (TilePortal)tile;
                    if (!tPortal.getMasterPos().equals((Object)this.field_174879_c) || tPortal.updateTime == time) continue;
                    if (!setHidden) {
                        this.field_145850_b.func_184134_a((double)spawn.func_177958_n() + 0.5, (double)spawn.func_177956_o() + 0.5, (double)spawn.func_177952_p() + 0.5, SoundEvents.field_187625_bm, SoundCategory.BLOCKS, 2.0f, 0.5f + this.field_145850_b.field_73012_v.nextFloat() * 0.1f, false);
                    }
                    ((TilePortal)tile).propRenderUpdate(time, !setHidden);
                }
            }
        }
    }

    public boolean onBlockActivated(EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            return !this.LT_REDSTONE.value;
        }
        InventoryUtils.handleHeldStackTransfer((int)0, (IInventory)this, (EntityPlayer)player);
        return true;
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack prev = this.func_70301_a(0);
        super.func_70299_a(index, stack);
        if (DEFeatures.dislocatorBound.isValid(prev) && !DEFeatures.dislocatorBound.isPlayer(prev)) {
            DislocatorLinkHandler.removeLink(this.field_145850_b, prev);
        }
        this.IS_BOUND.value = false;
        if (this.func_70301_a(0).func_190926_b() && this.ACTIVE.value) {
            this.deactivate();
        } else if (!this.func_70301_a(0).func_190926_b()) {
            this.attemptIgnition();
            this.checkIn();
        }
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack prev = this.func_70301_a(0);
        ItemStack ret = super.func_70298_a(index, count);
        if (DEFeatures.dislocatorBound.isValid(prev) && !DEFeatures.dislocatorBound.isPlayer(prev)) {
            DislocatorLinkHandler.removeLink(this.field_145850_b, prev);
        }
        this.IS_BOUND.value = false;
        if (this.func_70301_a(0).func_190926_b() && this.ACTIVE.value) {
            this.deactivate();
        } else if (!this.func_70301_a(0).func_190926_b()) {
            this.attemptIgnition();
            this.checkIn();
        }
        return ret;
    }

    private void checkIn() {
        ItemStack stack = this.func_70301_a(0);
        if (DEFeatures.dislocatorBound.isValid(stack) && !DEFeatures.dislocatorBound.isPlayer(stack)) {
            DislocatorLinkHandler.updateLink(this.field_145850_b, stack, this.field_174879_c, this.field_145850_b.field_73011_w.getDimension());
            this.IS_BOUND.value = true;
        } else {
            this.IS_BOUND.value = false;
        }
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() instanceof Dislocator;
    }

    public void handleEntityTeleport(Entity entity) {
        if (this.field_145850_b.field_72995_K || this.teleportQ.contains(entity) || this.coolDownMap.containsKey(entity.func_145782_y())) {
            return;
        }
        if (this.arrivalsMap.containsKey(entity.func_145782_y())) {
            if (entity instanceof EntityPlayer && this.arrivalsMap.get(entity.func_145782_y()) < 10) {
                new PacketCustom((Object)"DEPCChannel", 1).writePos(this.field_174879_c).sendToPlayer((EntityPlayer)entity);
            }
            this.arrivalsMap.put(entity.func_145782_y(), 10);
            return;
        }
        this.coolDownMap.put(entity.func_145782_y(), 10);
        this.teleportQ.add(entity);
    }

    public void deactivate() {
        IBlockState state;
        if (!this.field_145850_b.field_72995_K) {
            this.ACTIVE.value = false;
        }
        if ((state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() == DEFeatures.dislocatorReceptacle) {
            this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)DislocatorReceptacle.ACTIVE, (Comparable)Boolean.valueOf(false)));
        }
        for (BlockPos checkPos : BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177982_a(-1, -1, -1), (BlockPos)this.field_174879_c.func_177982_a(1, 1, 1))) {
            TileEntity tile = this.field_145850_b.func_175625_s(checkPos);
            if (!(tile instanceof TilePortal) || !((TilePortal)tile).getMasterPos().equals((Object)this.field_174879_c)) continue;
            this.field_145850_b.func_175698_g(tile.func_174877_v());
        }
        this.updateBlock();
    }

    public boolean attemptIgnition() {
        this.NEW_OFFSETS.value = true;
        ItemStack stack = this.func_70301_a(0);
        if (!(stack.func_77973_b() instanceof Dislocator && ((Dislocator)stack.func_77973_b()).getLocation(stack, this.field_145850_b) != null || DEFeatures.dislocatorBound.isValid(stack))) {
            return false;
        }
        PairKV<EnumFacing.Axis, List<BlockPos>> portalConfiguration = this.scanConfigurations();
        if (portalConfiguration != null) {
            this.igniting = true;
            for (BlockPos portalBlock : (List)portalConfiguration.getValue()) {
                this.field_145850_b.func_175656_a(portalBlock, DEFeatures.portal.func_176223_P().func_177226_a(Portal.AXIS, (Comparable)portalConfiguration.getKey()));
                TileEntity tile = this.field_145850_b.func_175625_s(portalBlock);
                if (!(tile instanceof TilePortal)) continue;
                ((TilePortal)tile).setMasterPos(this.field_174879_c);
            }
            this.ACTIVE.value = true;
            this.ACTIVE_AXIS.value = (Enum)portalConfiguration.getKey();
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_177230_c() == DEFeatures.dislocatorReceptacle) {
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)DislocatorReceptacle.ACTIVE, (Comparable)Boolean.valueOf(true)));
            }
            this.updateBlock();
            this.igniting = false;
            if (DEFeatures.dislocatorBound.isValid(stack) && !DEFeatures.dislocatorBound.isPlayer(stack)) {
                this.updateSpawnBlock((List)portalConfiguration.getValue());
                this.updateLinkBlock((List)portalConfiguration.getValue());
            }
            return true;
        }
        return false;
    }

    private void updateSpawnBlock(List<BlockPos> rawBlocks) {
        HashMap levelMap = new HashMap();
        rawBlocks.forEach(block -> levelMap.computeIfAbsent(block.func_177956_o(), integer -> new ArrayList()).add(block));
        LinkedList levels = new LinkedList(levelMap.keySet());
        levels.sort(Comparator.naturalOrder());
        ArrayList<BlockPos> foundValid = new ArrayList<BlockPos>();
        Iterator iterator = levels.iterator();
        while (iterator.hasNext()) {
            int level = (Integer)iterator.next();
            List blocks = (List)levelMap.get(level);
            for (BlockPos pos : blocks) {
                if (!this.field_145850_b.func_175623_d(pos.func_177984_a()) && this.field_145850_b.func_180495_p(pos.func_177984_a()).func_177230_c() != DEFeatures.portal) continue;
                foundValid.add(pos);
            }
            if (foundValid.isEmpty()) continue;
            break;
        }
        if (foundValid.isEmpty()) {
            this.SPAWN_POS.vec = new Vec3I(0, -999, 0);
            return;
        }
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        for (BlockPos pos : foundValid) {
            if (pos.func_177958_n() > maxX) {
                maxX = pos.func_177958_n();
            }
            if (pos.func_177956_o() > maxY) {
                maxY = pos.func_177956_o();
            }
            if (pos.func_177952_p() > maxZ) {
                maxZ = pos.func_177952_p();
            }
            if (pos.func_177958_n() < minX) {
                minX = pos.func_177958_n();
            }
            if (pos.func_177956_o() < minY) {
                minY = pos.func_177956_o();
            }
            if (pos.func_177952_p() >= minZ) continue;
            minZ = pos.func_177952_p();
        }
        Vec3D center = new Vec3D((double)(minX + (maxX - minX) / 2) + 0.5, (double)(minY + (maxY - minY) / 2) + 0.5, (double)(minZ + (maxZ - minZ) / 2) + 0.5);
        BlockPos closestPos = (BlockPos)foundValid.get(0);
        double closest = 1.0E7;
        for (BlockPos pos : foundValid) {
            double dist = Utils.getDistanceSq((double)((double)pos.func_177958_n() + 0.5), (double)((double)pos.func_177956_o() + 0.5), (double)((double)pos.func_177952_p() + 0.5), (double)center.x, (double)center.y, (double)center.z);
            if (!(dist < closest)) continue;
            closest = dist;
            closestPos = pos;
        }
        this.setSpawnPos(closestPos);
    }

    private void updateLinkBlock(List<BlockPos> rawBlocks) {
        if (rawBlocks.isEmpty()) {
            this.CRYSTAL_LINK_POS.vec = new Vec3I(0, -999, 0);
            return;
        }
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        for (BlockPos pos : rawBlocks) {
            if (pos.func_177958_n() > maxX) {
                maxX = pos.func_177958_n();
            }
            if (pos.func_177956_o() > maxY) {
                maxY = pos.func_177956_o();
            }
            if (pos.func_177952_p() > maxZ) {
                maxZ = pos.func_177952_p();
            }
            if (pos.func_177958_n() < minX) {
                minX = pos.func_177958_n();
            }
            if (pos.func_177956_o() < minY) {
                minY = pos.func_177956_o();
            }
            if (pos.func_177952_p() >= minZ) continue;
            minZ = pos.func_177952_p();
        }
        Vec3D center = new Vec3D((double)(minX + (maxX - minX) / 2) + 0.5, (double)(minY + (maxY - minY) / 2) + 0.5, (double)(minZ + (maxZ - minZ) / 2) + 0.5);
        BlockPos closestPos = rawBlocks.get(0);
        double closest = 1.0E7;
        for (BlockPos pos : rawBlocks) {
            double dist = Utils.getDistanceSq((double)((double)pos.func_177958_n() + 0.5), (double)((double)pos.func_177956_o() + 0.5), (double)((double)pos.func_177952_p() + 0.5), (double)center.x, (double)center.y, (double)center.z);
            if (!(dist < closest)) continue;
            closest = dist;
            closestPos = pos;
        }
        this.setLinkPos(closestPos);
    }

    private PairKV<EnumFacing.Axis, List<BlockPos>> scanConfigurations() {
        List<BlockPos> portalBlocks;
        ArrayList<Object> scanned = new ArrayList<BlockPos>();
        for (BlockPos offset : FacingUtils.AROUND_X) {
            portalBlocks = this.scanFromOrigin(this.field_174879_c.func_177971_a((Vec3i)offset), EnumFacing.Axis.X, scanned);
            if (portalBlocks == null) continue;
            return new PairKV((Object)EnumFacing.Axis.X, portalBlocks);
        }
        scanned = new ArrayList();
        for (BlockPos offset : FacingUtils.AROUND_Y) {
            portalBlocks = this.scanFromOrigin(this.field_174879_c.func_177971_a((Vec3i)offset), EnumFacing.Axis.Y, scanned);
            if (portalBlocks == null) continue;
            return new PairKV((Object)EnumFacing.Axis.Y, portalBlocks);
        }
        scanned = new ArrayList();
        for (BlockPos offset : FacingUtils.AROUND_Z) {
            portalBlocks = this.scanFromOrigin(this.field_174879_c.func_177971_a((Vec3i)offset), EnumFacing.Axis.Z, scanned);
            if (portalBlocks == null) continue;
            return new PairKV((Object)EnumFacing.Axis.Z, portalBlocks);
        }
        return null;
    }

    private List<BlockPos> scanFromOrigin(BlockPos scanOrigin, EnumFacing.Axis scanAxis, List<BlockPos> alreadyScanned) {
        if (!this.field_145850_b.func_175623_d(scanOrigin) || alreadyScanned.contains(scanOrigin)) {
            return null;
        }
        ArrayList<BlockPos> scannedBlocks = new ArrayList<BlockPos>();
        if (this.scanPortal(scanOrigin, scanOrigin, scanAxis, scannedBlocks, alreadyScanned)) {
            return scannedBlocks;
        }
        return null;
    }

    private boolean scanPortal(BlockPos scanPos, BlockPos origin, EnumFacing.Axis scanAxis, List<BlockPos> scanList, List<BlockPos> blackList) {
        Vec3D vec3D = new Vec3D(scanPos);
        Vec3D vec3D2 = new Vec3D(origin);
        if (Utils.getDistanceAtoB((Vec3D)vec3D, (Vec3D)vec3D2) > 100.0) {
            return false;
        }
        scanList.add(scanPos);
        for (EnumFacing facing : FacingUtils.getFacingsAroundAxis((EnumFacing.Axis)scanAxis)) {
            BlockPos nextPos = scanPos.func_177972_a(facing);
            if (scanList.contains(nextPos) || this.isFrame(nextPos)) continue;
            if (this.field_145850_b.func_175623_d(nextPos)) {
                if (this.scanPortal(nextPos, origin, scanAxis, scanList, blackList)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean isFrame(BlockPos pos) {
        IBlockState state = this.field_145850_b.func_180495_p(pos);
        return state.func_177230_c() == DEFeatures.infusedObsidian || state.func_177230_c() == DEFeatures.dislocatorReceptacle;
    }

    @Override
    public BlockPos getArrivalPos(String linkID) {
        if (!(this.ACTIVE.value && DEFeatures.dislocatorBound.isValid(this.func_70301_a(0)) && DEFeatures.dislocatorBound.getLinkID(this.func_70301_a(0)).equals(linkID))) {
            return null;
        }
        return this.SPAWN_POS.vec.y == -999 ? null : this.getSpawnPos();
    }

    @Override
    public void entityArriving(Entity entity) {
        Entity rootEntity = entity.func_184208_bv();
        PassengerHelper passengerHelper = new PassengerHelper(rootEntity);
        passengerHelper.forEach(e -> this.arrivalsMap.put(e.func_145782_y(), 10));
    }

    public void setSpawnPos(BlockPos spawnPos) {
        this.SPAWN_POS.vec.set(this.field_174879_c.func_177973_b((Vec3i)spawnPos));
    }

    protected BlockPos getSpawnPos() {
        return this.field_174879_c.func_177973_b((Vec3i)this.SPAWN_POS.vec.getPos());
    }

    public void setLinkPos(BlockPos spawnPos) {
        this.CRYSTAL_LINK_POS.vec.set(this.field_174879_c.func_177973_b((Vec3i)spawnPos));
    }

    protected BlockPos getLinkPos() {
        return this.field_174879_c.func_177973_b((Vec3i)this.CRYSTAL_LINK_POS.vec.getPos());
    }

    @Optional.Method(modid="appliedenergistics2")
    public boolean prepareToMove() {
        return true;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void doneMoving() {
        this.checkIn();
    }

    @Override
    public Iterable<BlockPos> getBlocksForFrameMove() {
        if (this.ACTIVE.value) {
            for (BlockPos offset : FacingUtils.getAroundAxis((EnumFacing.Axis)((EnumFacing.Axis)this.ACTIVE_AXIS.value))) {
                BlockPos next = this.field_174879_c.func_177971_a((Vec3i)offset);
                if (this.field_145850_b.func_180495_p(next).func_177230_c() != DEFeatures.portal) continue;
                HashSet<BlockPos> blocks = new HashSet<BlockPos>();
                this.findActiveBlocksOnAxis((EnumFacing.Axis)this.ACTIVE_AXIS.value, next, blocks);
                return blocks;
            }
        } else {
            PairKV<EnumFacing.Axis, List<BlockPos>> config = this.scanConfigurations();
            if (config != null) {
                HashSet<BlockPos> blocks = new HashSet<BlockPos>();
                for (BlockPos ppos : (List)config.getValue()) {
                    for (BlockPos offset : FacingUtils.getAroundAxis((EnumFacing.Axis)((EnumFacing.Axis)config.getKey()))) {
                        BlockPos next = ppos.func_177971_a((Vec3i)offset);
                        if (blocks.contains(next) || this.field_145850_b.func_180495_p(next).func_177230_c() != DEFeatures.infusedObsidian) continue;
                        blocks.add(next);
                    }
                }
                return blocks;
            }
        }
        return Collections.emptyList();
    }

    public void findActiveBlocksOnAxis(EnumFacing.Axis axis, BlockPos pos, HashSet<BlockPos> blocks) {
        blocks.add(pos);
        for (BlockPos offset : FacingUtils.getAroundAxis((EnumFacing.Axis)axis)) {
            BlockPos next = pos.func_177971_a((Vec3i)offset);
            if (blocks.contains(next)) continue;
            IBlockState state = this.field_145850_b.func_180495_p(next);
            if (state.func_177230_c() == DEFeatures.portal) {
                this.findActiveBlocksOnAxis(axis, next, blocks);
                continue;
            }
            if (state.func_177230_c() != DEFeatures.infusedObsidian) continue;
            blocks.add(next);
        }
    }

    public void finishMove(BlockPos pos, HashSet<BlockPos> blocks) {
        for (EnumFacing facing : FacingUtils.getFacingsAroundAxis((EnumFacing.Axis)((EnumFacing.Axis)this.ACTIVE_AXIS.value))) {
            IBlockState state;
            BlockPos np = pos.func_177972_a(facing);
            if (blocks.contains(np) || (state = this.field_145850_b.func_180495_p(np)).func_177230_c() != DEFeatures.portal) continue;
            TileEntity tile = this.field_145850_b.func_175625_s(np);
            if (tile instanceof TilePortal) {
                ((TilePortal)tile).frameMoving = false;
            }
            blocks.add(np);
            this.finishMove(np, blocks);
        }
    }

    protected void setCrystalPos(BlockPos crystalPos) {
        this.LINKED_CRYSTAL.vec.set(this.field_174879_c.func_177973_b((Vec3i)crystalPos));
    }

    protected BlockPos getCrystalPos() {
        return this.field_174879_c.func_177973_b((Vec3i)this.LINKED_CRYSTAL.vec.getPos());
    }

    private TileDislocatorReceptacle getRemoteReceptacle() {
        return this.getRemoteReceptacle(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TileDislocatorReceptacle getRemoteReceptacle(boolean skipRemoteCheck) {
        MinecraftServer server;
        TileEntity tile;
        if (!this.IS_BOUND.value || !this.ACTIVE.value) {
            return null;
        }
        if (this.invalidLinkTime > 0) {
            --this.invalidLinkTime;
            return null;
        }
        if (this.remotePosCache == null) {
            ItemStack stack = this.func_70301_a(0);
            if (!DEFeatures.dislocatorBound.isValid(stack) || DEFeatures.dislocatorBound.isPlayer(stack)) return null;
            tile = DislocatorLinkHandler.getTargetTile(this.field_145850_b, stack);
            if (tile instanceof TileDislocatorReceptacle) {
                this.remotePosCache = tile.func_174877_v();
                this.remoteDimCache = tile.func_145831_w().field_73011_w.getDimension();
            } else {
                this.invalidLinkTime = 100;
                return null;
            }
        }
        if ((server = this.field_145850_b.func_73046_m()) == null) return null;
        tile = server.func_71218_a(this.remoteDimCache).func_175625_s(this.remotePosCache);
        if (tile instanceof TileDislocatorReceptacle) {
            if (skipRemoteCheck) {
                return (TileDislocatorReceptacle)tile;
            }
            if (((TileDislocatorReceptacle)tile).ACTIVE.value && ((TileDislocatorReceptacle)tile).getRemoteReceptacle(true) == this) {
                return (TileDislocatorReceptacle)tile;
            }
        }
        this.remotePosCache = null;
        return null;
    }

    private ICrystalLink getRemoteCrystal() {
        MinecraftServer server;
        TileDislocatorReceptacle tile = this.getRemoteReceptacle();
        if (tile != null && (server = this.field_145850_b.func_73046_m()) != null && tile.LINKED_CRYSTAL.vec.y != -999) {
            TileEntity crystal = server.func_71218_a(this.remoteDimCache).func_175625_s(tile.getCrystalPos());
            if (crystal instanceof IENetEffectTile) {
                this.REMOTE_CRYSTAL_TIER.value = (byte)((IENetEffectTile)crystal).getTier();
                return (ICrystalLink)crystal;
            }
            return null;
        }
        return null;
    }

    @Override
    @Nonnull
    public List<BlockPos> getLinks() {
        if (this.LINKED_CRYSTAL.vec.y != -999) {
            return Collections.singletonList(this.getCrystalPos());
        }
        return Collections.emptyList();
    }

    @Override
    public boolean binderUsed(EntityPlayer player, BlockPos linkTarget, EnumFacing sideClicked) {
        return false;
    }

    @Override
    public boolean createLink(ICrystalLink otherCrystal) {
        this.setCrystalPos(((TileEntity)otherCrystal).func_174877_v());
        return true;
    }

    @Override
    public void breakLink(BlockPos otherCrystal) {
        this.LINKED_CRYSTAL.vec = new Vec3I(0, -999, 0);
    }

    @Override
    public int balanceMode() {
        ICrystalLink remote = this.getRemoteCrystal();
        return remote != null ? remote.balanceMode() : 1;
    }

    @Override
    public int maxLinks() {
        return 1;
    }

    @Override
    public int maxLinkRange() {
        return 32;
    }

    @Override
    public int getEnergyStored() {
        ICrystalLink remote = this.getRemoteCrystal();
        return remote != null ? remote.getEnergyStored() : 0;
    }

    @Override
    public int getMaxEnergyStored() {
        ICrystalLink remote = this.getRemoteCrystal();
        return remote != null ? remote.getMaxEnergyStored() : 0;
    }

    @Override
    public void modifyEnergyStored(int energy) {
        ICrystalLink remote = this.getRemoteCrystal();
        if (remote != null) {
            remote.modifyEnergyStored(energy);
        }
    }

    @Override
    public Vec3D getBeamLinkPos(BlockPos linkTo) {
        double dist = FacingUtils.destanceInDirection((BlockPos)this.field_174879_c, (BlockPos)linkTo, (EnumFacing)FacingUtils.getAxisFaces((EnumFacing.Axis)((EnumFacing.Axis)this.ACTIVE_AXIS.value))[0]);
        Vec3D vec = Vec3D.getCenter((BlockPos)this.getLinkPos());
        EnumFacing facing = dist > 0.0 ? FacingUtils.getAxisFaces((EnumFacing.Axis)((EnumFacing.Axis)this.ACTIVE_AXIS.value))[0] : FacingUtils.getAxisFaces((EnumFacing.Axis)((EnumFacing.Axis)this.ACTIVE_AXIS.value))[1];
        vec.add((double)facing.func_82601_c() * 0.35, (double)facing.func_96559_d() * 0.35, (double)facing.func_82599_e() * 0.35);
        return vec;
    }

    @Override
    public boolean renderBeamTermination() {
        return true;
    }

    @Override
    public ENetFXHandler createServerFXHandler() {
        return new ENetFXHandlerServer(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ENetFXHandler createClientFXHandler() {
        return new ENetFXHandlerClient(this);
    }

    @Override
    public boolean hasStaticFX() {
        return false;
    }

    @Override
    public CrystalGLFXBase createStaticFX() {
        return null;
    }

    @Override
    public LinkedList<Byte> getFlowRates() {
        return new LinkedList<Byte>(Collections.singletonList(this.LINKED_FLOW_RATE.value));
    }

    @Override
    public int getTier() {
        return this.REMOTE_CRYSTAL_TIER.value;
    }

    @Override
    public int getIDHash() {
        if (!this.hashCached) {
            this.hashID = this.field_174879_c.hashCode();
            this.hashCached = true;
        }
        return this.hashID;
    }

    private static class PassengerHelper {
        public Entity entity;
        public LinkedList<PassengerHelper> passengers = new LinkedList();

        public PassengerHelper(Entity entity) {
            this.entity = entity;
            for (Entity passenger : entity.func_184188_bt()) {
                this.passengers.add(new PassengerHelper(passenger));
            }
        }

        public void forEach(Consumer<Entity> action) {
            action.accept(this.entity);
            this.passengers.forEach((? super T helper) -> helper.forEach(action));
        }
    }
}

