/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.fx;

import blusunrize.immersiveengineering.api.Lib;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ParticleFractal
extends Particle {
    public static final Deque<ParticleFractal> PARTICLE_FRACTAL_DEQUE = new ArrayDeque<ParticleFractal>();
    public static final float[][] COLOUR_RED = new float[][]{{0.79f, 0.31f, 0.31f, 0.5f}, {1.0f, 0.97f, 0.87f, 0.75f}};
    public static final float[][] COLOUR_ORANGE = new float[][]{{Lib.COLOUR_F_ImmersiveOrange[0], Lib.COLOUR_F_ImmersiveOrange[1], Lib.COLOUR_F_ImmersiveOrange[2], 0.5f}, {1.0f, 0.97f, 0.87f, 0.75f}};
    public static final float[][] COLOUR_LIGHTNING = new float[][]{{0.3019608f, 0.2901961f, 0.59607846f, 0.75f}, {1.0f, 1.0f, 1.0f, 1.0f}};
    private Vec3d[] pointsList;
    private float[] colourOut;
    private float[] colourIn;

    public ParticleFractal(World world, double x, double y, double z, double speedX, double speedY, double speedZ, Vec3d direction, double scale, int maxAge, int points, float[] colourOut, float[] colourIn) {
        super(world, x, y, z, speedX, speedY, speedZ);
        this.field_70547_e = maxAge;
        this.field_187129_i *= (double)0.009f;
        this.field_187130_j *= (double)0.009f;
        this.field_187131_k *= (double)0.009f;
        this.colourOut = colourOut;
        this.colourIn = colourIn;
        this.pointsList = new Vec3d[points];
        direction = direction.func_186678_a(scale);
        Vec3d startPos = direction.func_186678_a(-0.5);
        Vec3d end = direction.func_186678_a(0.5);
        Vec3d dist = end.func_178788_d(startPos);
        for (int i = 0; i < points; ++i) {
            Vec3d sub = startPos.func_72441_c(dist.field_72450_a / (double)points * (double)i, dist.field_72448_b / (double)points * (double)i, dist.field_72449_c / (double)points * (double)i);
            double fixPointDist = (i - points / 2) / (points / 2);
            double mod = scale * 1.0 - 0.45 * Math.abs(fixPointDist);
            double offX = (this.field_187136_p.nextDouble() - 0.5) * mod;
            double offY = (this.field_187136_p.nextDouble() - 0.5) * mod;
            double offZ = (this.field_187136_p.nextDouble() - 0.5) * mod;
            this.pointsList[i] = sub.func_72441_c(offX, offY, offZ);
        }
    }

    public ParticleFractal(World world, double x, double y, double z, Vec3d direction, double scale, float[] colourOut, float[] colourIn) {
        this(world, x, y, z, 0.0, 0.0, 0.0, direction, scale, 10, 16, colourOut, colourIn);
    }

    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        PARTICLE_FRACTAL_DEQUE.add(this);
    }

    public void render(Tessellator tessellator, BufferBuilder buffer, float partialTicks) {
        int i;
        float mod = ((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e;
        int iStart = 0;
        int iEnd = this.pointsList.length;
        if ((double)mod >= 0.76) {
            float rem = (mod - 0.7599f) % 0.25f * 48.0f / 2.0f;
            iStart = (int)((double)iStart + Math.ceil(rem));
            iEnd = (int)((double)iEnd - Math.floor(rem));
        }
        mod = 0.3f + mod * mod;
        Vec3d[] vectorsScaled = new Vec3d[iEnd];
        GlStateManager.func_187441_d((float)4.0f);
        buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        for (i = iStart; i < iEnd; ++i) {
            Vec3d vecRender = this.pointsList[i].func_186678_a((double)mod);
            buffer.func_181662_b(this.field_187126_f + vecRender.field_72450_a, this.field_187127_g + vecRender.field_72448_b, this.field_187128_h + vecRender.field_72449_c).func_181666_a(this.colourOut[0], this.colourOut[1], this.colourOut[2], this.colourOut[3]).func_181675_d();
            vectorsScaled[i] = vecRender;
        }
        tessellator.func_78381_a();
        GlStateManager.func_187441_d((float)1.0f);
        buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        for (i = iEnd - 1; i >= iStart; --i) {
            buffer.func_181662_b(this.field_187126_f + vectorsScaled[i].field_72450_a, this.field_187127_g + vectorsScaled[i].field_72448_b, this.field_187128_h + vectorsScaled[i].field_72449_c).func_181666_a(this.colourIn[0], this.colourIn[1], this.colourIn[2], this.colourIn[3]).func_181675_d();
        }
        tessellator.func_78381_a();
        GL11.glPointSize((float)8.0f);
        buffer.func_181668_a(0, DefaultVertexFormats.field_181706_f);
        for (i = iStart; i < iEnd; ++i) {
            buffer.func_181662_b(this.field_187126_f + vectorsScaled[i].field_72450_a, this.field_187127_g + vectorsScaled[i].field_72448_b, this.field_187128_h + vectorsScaled[i].field_72449_c).func_181666_a(this.colourOut[0], this.colourOut[1], this.colourOut[2], this.colourOut[3]).func_181675_d();
        }
        tessellator.func_78381_a();
        GL11.glPointSize((float)2.0f);
        buffer.func_181668_a(0, DefaultVertexFormats.field_181706_f);
        for (i = iEnd - 1; i >= iStart; --i) {
            buffer.func_181662_b(this.field_187126_f + vectorsScaled[i].field_72450_a, this.field_187127_g + vectorsScaled[i].field_72448_b, this.field_187128_h + vectorsScaled[i].field_72449_c).func_181666_a(this.colourIn[0], this.colourIn[1], this.colourIn[2], this.colourIn[3]).func_181675_d();
        }
        tessellator.func_78381_a();
    }
}

