/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.world.generation;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import logictechcorp.libraryex.event.LibExEventFactory;
import logictechcorp.libraryex.world.biome.data.BiomeData;
import logictechcorp.netherex.NetherEx;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkGeneratorHell;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCavesHell;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.MapGenNetherBridge;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ChunkGeneratorNetherEx
extends ChunkGeneratorHell {
    private final World world;
    private final Random random;
    private final boolean generateStructures;
    private NoiseGeneratorOctaves lowerNoiseGen;
    private NoiseGeneratorOctaves upperNoiseGen;
    private NoiseGeneratorOctaves noiseLevelsGen;
    private NoiseGeneratorOctaves soulSandGravelNoiseGen;
    private NoiseGeneratorOctaves netherrackNoiseGen;
    private NoiseGeneratorOctaves scaleNoiseGen;
    private NoiseGeneratorOctaves depthNoiseGen;
    private NoiseGeneratorPerlin terrainNoiseGen;
    private double[] heightmap;
    private double[] netherrackNoise = new double[256];
    private double[] soulSandNoise = new double[256];
    private double[] gravelNoise = new double[256];
    private double[] terrainNoise = new double[256];
    private double[] noiseLevels;
    private double[] lowerNoiseData;
    private double[] upperNoiseData;
    private double[] scaleNoise;
    private double[] depthNoise;
    private Biome[] biomesForGeneration;
    private MapGenBase netherCaves = new MapGenCavesHell();
    private MapGenNetherBridge netherFortress = new MapGenNetherBridge();

    public ChunkGeneratorNetherEx(World world, boolean generateStructures, long seed) {
        super(world, generateStructures, seed);
        this.world = world;
        this.random = new Random(seed);
        this.generateStructures = generateStructures;
        this.lowerNoiseGen = new NoiseGeneratorOctaves(this.random, 16);
        this.upperNoiseGen = new NoiseGeneratorOctaves(this.random, 16);
        this.noiseLevelsGen = new NoiseGeneratorOctaves(this.random, 8);
        this.soulSandGravelNoiseGen = new NoiseGeneratorOctaves(this.random, 4);
        this.netherrackNoiseGen = new NoiseGeneratorOctaves(this.random, 4);
        this.scaleNoiseGen = new NoiseGeneratorOctaves(this.random, 10);
        this.depthNoiseGen = new NoiseGeneratorOctaves(this.random, 16);
        this.terrainNoiseGen = new NoiseGeneratorPerlin(this.random, 4);
        InitNoiseGensEvent.ContextHell ctx = new InitNoiseGensEvent.ContextHell(this.lowerNoiseGen, this.upperNoiseGen, this.noiseLevelsGen, this.soulSandGravelNoiseGen, this.netherrackNoiseGen, this.scaleNoiseGen, this.depthNoiseGen);
        ctx = (InitNoiseGensEvent.ContextHell)TerrainGen.getModdedNoiseGenerators((World)this.world, (Random)this.random, (InitNoiseGensEvent.Context)ctx);
        this.lowerNoiseGen = ctx.getLPerlin1();
        this.upperNoiseGen = ctx.getLPerlin2();
        this.noiseLevelsGen = ctx.getPerlin();
        this.soulSandGravelNoiseGen = ctx.getPerlin2();
        this.netherrackNoiseGen = ctx.getPerlin3();
        this.scaleNoiseGen = ctx.getScale();
        this.depthNoiseGen = ctx.getDepth();
        this.netherCaves = TerrainGen.getModdedMapGen((MapGenBase)this.netherCaves, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.NETHER_CAVE);
        MapGenBase replacedNetherFortress = TerrainGen.getModdedMapGen((MapGenBase)this.netherFortress, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.NETHER_BRIDGE);
        if (replacedNetherFortress instanceof MapGenNetherBridge) {
            this.netherFortress = (MapGenNetherBridge)replacedNetherFortress;
        }
        world.func_181544_b(31);
    }

    public void func_185936_a(int chunkX, int chunkZ, ChunkPrimer primer) {
        this.biomesForGeneration = this.world.func_72959_q().func_76937_a(this.biomesForGeneration, chunkX * 4 - 2, chunkZ * 4 - 2, 10, 10);
        this.heightmap = this.generateHeightMap(this.heightmap, chunkX * 4, 0, chunkZ * 4, 5, 17, 5);
        for (int x = 0; x < 4; ++x) {
            for (int z = 0; z < 4; ++z) {
                for (int y = 0; y < 16; ++y) {
                    double d1 = this.heightmap[(x * 5 + z) * 17 + y];
                    double d2 = this.heightmap[(x * 5 + z + 1) * 17 + y];
                    double d3 = this.heightmap[((x + 1) * 5 + z) * 17 + y];
                    double d4 = this.heightmap[((x + 1) * 5 + z + 1) * 17 + y];
                    double d5 = (this.heightmap[(x * 5 + z) * 17 + y + 1] - d1) * 0.125;
                    double d6 = (this.heightmap[(x * 5 + z + 1) * 17 + y + 1] - d2) * 0.125;
                    double d7 = (this.heightmap[((x + 1) * 5 + z) * 17 + y + 1] - d3) * 0.125;
                    double d8 = (this.heightmap[((x + 1) * 5 + z + 1) * 17 + y + 1] - d4) * 0.125;
                    for (int y2 = 0; y2 < 8; ++y2) {
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.25;
                        double d13 = (d4 - d2) * 0.25;
                        for (int x2 = 0; x2 < 4; ++x2) {
                            double d15 = d10;
                            double d16 = (d11 - d10) * 0.25;
                            for (int z2 = 0; z2 < 4; ++z2) {
                                int posX = x2 + x * 4;
                                int posY = y2 + y * 8;
                                int posZ = z2 + z * 4;
                                IBlockState state = null;
                                if (posY < 32) {
                                    state = Blocks.field_150353_l.func_176223_P();
                                }
                                if (d15 > 0.0) {
                                    state = Blocks.field_150424_aL.func_176223_P();
                                }
                                primer.func_177855_a(posX, posY, posZ, state);
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void func_185937_b(int chunkX, int chunkZ, ChunkPrimer primer) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)chunkX, (int)chunkZ, (ChunkPrimer)primer, (World)this.world)) {
            return;
        }
        this.soulSandNoise = this.soulSandGravelNoiseGen.func_76304_a(this.soulSandNoise, chunkX * 16, chunkZ * 16, 0, 16, 16, 1, 0.03125, 0.03125, 1.0);
        this.gravelNoise = this.soulSandGravelNoiseGen.func_76304_a(this.gravelNoise, chunkX * 16, 109, chunkZ * 16, 16, 1, 16, 0.03125, 1.0, 0.03125);
        this.netherrackNoise = this.netherrackNoiseGen.func_76304_a(this.netherrackNoise, chunkX * 16, chunkZ * 16, 0, 16, 16, 1, 0.0625, 0.0625, 0.0625);
        BlockPos blockPos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
        for (int posX = 0; posX < 16; ++posX) {
            for (int posZ = 0; posZ < 16; ++posZ) {
                BiomeData biomeData = NetherEx.BIOME_DATA_MANAGER.getBiomeData(this.world.func_180494_b(blockPos.func_177982_a(posX, 0, posZ)));
                IBlockState surfaceState = Blocks.field_150424_aL.func_176223_P();
                IBlockState subSurfaceState = Blocks.field_150424_aL.func_176223_P();
                IBlockState liquidState = Blocks.field_150353_l.func_176223_P();
                if (biomeData != BiomeData.EMPTY) {
                    surfaceState = biomeData.getBiomeBlock(BiomeData.BlockType.SURFACE_BLOCK);
                    subSurfaceState = biomeData.getBiomeBlock(BiomeData.BlockType.SUBSURFACE_BLOCK);
                    liquidState = biomeData.getBiomeBlock(BiomeData.BlockType.LIQUID_BLOCK);
                }
                boolean wasLastBlockNonSolid = false;
                for (int posY = 127; posY >= 0; --posY) {
                    if (posY < 127 - this.random.nextInt(5) && posY > this.random.nextInt(5)) {
                        IBlockState checkState = primer.func_177856_a(posX, posY, posZ);
                        if (checkState.func_185904_a() == Material.field_151579_a) {
                            wasLastBlockNonSolid = true;
                            continue;
                        }
                        if (checkState == Blocks.field_150424_aL.func_176223_P()) {
                            if (wasLastBlockNonSolid) {
                                if (posY < this.world.func_181545_F()) {
                                    primer.func_177855_a(posX, posY, posZ, liquidState);
                                } else {
                                    primer.func_177855_a(posX, posY, posZ, surfaceState);
                                }
                            } else {
                                primer.func_177855_a(posX, posY, posZ, subSurfaceState);
                            }
                            wasLastBlockNonSolid = false;
                            continue;
                        }
                        if (checkState != Blocks.field_150353_l.func_176223_P()) continue;
                        primer.func_177855_a(posX, posY, posZ, liquidState);
                        wasLastBlockNonSolid = true;
                        continue;
                    }
                    primer.func_177855_a(posX, posY, posZ, Blocks.field_150357_h.func_176223_P());
                }
            }
        }
    }

    private double[] generateHeightMap(double[] heightMap, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ) {
        if (heightMap == null) {
            heightMap = new double[sizeX * sizeY * sizeZ];
        }
        ChunkGeneratorEvent.InitNoiseField event = new ChunkGeneratorEvent.InitNoiseField((IChunkGenerator)this, heightMap, posX, posY, posZ, sizeX, sizeY, sizeZ);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return event.getNoisefield();
        }
        this.scaleNoise = this.scaleNoiseGen.func_76304_a(this.scaleNoise, posX, posY, posZ, sizeX, 1, sizeZ, 1.0, 0.0, 1.0);
        this.depthNoise = this.depthNoiseGen.func_76304_a(this.depthNoise, posX, posY, posZ, sizeX, 1, sizeZ, 100.0, 0.0, 100.0);
        this.noiseLevels = this.noiseLevelsGen.func_76304_a(this.noiseLevels, posX, posY, posZ, sizeX, sizeY, sizeZ, 8.55515, 34.2206, 8.55515);
        this.lowerNoiseData = this.lowerNoiseGen.func_76304_a(this.lowerNoiseData, posX, posY, posZ, sizeX, sizeY, sizeZ, 684.412, 2053.236, 684.412);
        this.upperNoiseData = this.upperNoiseGen.func_76304_a(this.upperNoiseData, posX, posY, posZ, sizeX, sizeY, sizeZ, 684.412, 2053.236, 684.412);
        double[] heightAdjustments = new double[sizeY];
        for (int y = 0; y < sizeY; ++y) {
            heightAdjustments[y] = Math.cos((double)y * Math.PI * 6.0 / (double)sizeY) * 2.0;
            double adjustedY = y;
            if (y > sizeY / 2) {
                adjustedY = sizeY - 1 - y;
            }
            if (!(adjustedY < 4.0)) continue;
            adjustedY = 4.0 - adjustedY;
            int n = y;
            heightAdjustments[n] = heightAdjustments[n] - adjustedY * adjustedY * adjustedY * 10.0;
        }
        int posCounter = 0;
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                for (int y = 0; y < sizeY; ++y) {
                    double distance;
                    double heightAdjustment = heightAdjustments[y];
                    double lowerNoise = this.lowerNoiseData[posCounter] / 512.0;
                    double upperNoise = this.upperNoiseData[posCounter] / 512.0;
                    double noiseLevel = (this.noiseLevels[posCounter] / 10.0 + 1.0) / 2.0;
                    double height = noiseLevel < 0.0 ? lowerNoise : (noiseLevel > 1.0 ? upperNoise : lowerNoise + (upperNoise - lowerNoise) * noiseLevel);
                    height -= heightAdjustment;
                    if (y > sizeY - 4) {
                        distance = (float)(y - (sizeY - 4)) / 3.0f;
                        height = height * (1.0 - distance) + -10.0 * distance;
                    }
                    if ((double)y < 0.0) {
                        distance = (0.0 - (double)y) / 4.0;
                        distance = MathHelper.func_151237_a((double)distance, (double)0.0, (double)1.0);
                        height = height * (1.0 - distance) + -10.0 * distance;
                    }
                    heightMap[posCounter] = height;
                    ++posCounter;
                }
            }
        }
        return heightMap;
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        Biome biome;
        ChunkPrimer primer = new ChunkPrimer();
        this.random.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        this.func_185936_a(chunkX, chunkZ, primer);
        this.biomesForGeneration = this.world.func_72959_q().func_76933_b(this.biomesForGeneration, chunkX * 16, chunkZ * 16, 16, 16);
        this.func_185937_b(chunkX, chunkZ, primer);
        BlockPos pos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
        BiomeData biomeData = NetherEx.BIOME_DATA_MANAGER.getBiomeData(this.world.func_180494_b(pos.func_177982_a(16, 0, 16)));
        if (biomeData != BiomeData.EMPTY && (biome = biomeData.getBiome()).getRegistryName().func_110624_b().equals("biomesoplenty") && ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)chunkX, (int)chunkZ, (ChunkPrimer)primer, (World)this.world)) {
            this.terrainNoise = this.terrainNoiseGen.func_151599_a(this.terrainNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 0.0625, 0.0625, 1.0);
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    biome.func_180622_a(this.world, this.random, primer, chunkX * 16 + x, chunkZ * 16 + z, this.terrainNoise[x + z * 16]);
                }
            }
        }
        this.netherCaves.func_186125_a(this.world, chunkX, chunkZ, primer);
        if (this.generateStructures && biomeData != null && biomeData.getBiome() == Biomes.field_76778_j) {
            this.netherFortress.func_186125_a(this.world, chunkX, chunkZ, primer);
        }
        Chunk chunk = new Chunk(this.world, primer, chunkX, chunkZ);
        byte[] biomeArray = chunk.func_76605_m();
        for (int i = 0; i < biomeArray.length; ++i) {
            Biome biome2 = this.biomesForGeneration[i];
            biomeArray[i] = (byte)Biome.func_185362_a((Biome)biome2);
        }
        chunk.func_76613_n();
        LibExEventFactory.onChunkGenerate((Chunk)chunk);
        return chunk;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        BlockPos blockPos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
        BiomeData biomeData = NetherEx.BIOME_DATA_MANAGER.getBiomeData(this.world.func_180494_b(blockPos.func_177982_a(16, 0, 16)));
        BlockFalling.field_149832_M = true;
        this.netherFortress.func_175794_a(this.world, this.random, chunkPos);
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.random, (int)chunkX, (int)chunkZ, (boolean)false);
        TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.random, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.CUSTOM);
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.random, (int)chunkX, (int)chunkZ, (boolean)false);
        LibExEventFactory.onPreDecorateBiome((World)this.world, (Random)this.random, (ChunkPos)chunkPos);
        LibExEventFactory.onDecorateBiome((World)this.world, (Random)this.random, (ChunkPos)chunkPos, (BlockPos)blockPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CUSTOM);
        if (biomeData != BiomeData.EMPTY && biomeData.useDefaultBiomeDecorations()) {
            biomeData.getBiome().func_180624_a(this.world, this.random, blockPos);
        }
        LibExEventFactory.onPostDecorateBiome((World)this.world, (Random)this.random, (ChunkPos)chunkPos);
        LibExEventFactory.onPreOreGen((World)this.world, (Random)this.random, (BlockPos)blockPos);
        LibExEventFactory.onOreGen((World)this.world, (Random)this.random, (WorldGenerator)new WorldGenMinable(Blocks.field_150350_a.func_176223_P(), 0, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150350_a)), (BlockPos)blockPos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM);
        LibExEventFactory.onPostOreGen((World)this.world, (Random)this.random, (BlockPos)blockPos);
        BlockFalling.field_149832_M = false;
    }

    public boolean func_185933_a(Chunk chunk, int chunkX, int chunkZ) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        if (creatureType == EnumCreatureType.MONSTER) {
            if (this.netherFortress.func_175795_b(pos)) {
                return this.netherFortress.func_75059_a();
            }
            if (this.netherFortress.func_175796_a(this.world, pos) && this.world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150385_bj) {
                return this.netherFortress.func_75059_a();
            }
        }
        Biome biome = this.world.func_180494_b(pos);
        BiomeData biomeData = NetherEx.BIOME_DATA_MANAGER.getBiomeData(biome);
        ArrayList<Biome.SpawnListEntry> spawns = new ArrayList<Biome.SpawnListEntry>(biome.func_76747_a(creatureType));
        if (biomeData != BiomeData.EMPTY) {
            spawns.addAll(biomeData.getEntitySpawns(creatureType));
        }
        return spawns;
    }

    public BlockPos func_180513_a(World world, String structureName, BlockPos pos, boolean force) {
        if ("Fortress".equalsIgnoreCase(structureName)) {
            return this.netherFortress != null ? this.netherFortress.func_180706_b(world, pos, force) : null;
        }
        return null;
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        if ("Fortress".equalsIgnoreCase(structureName)) {
            return this.netherFortress != null && this.netherFortress.func_175795_b(pos);
        }
        return false;
    }

    public void func_180514_a(Chunk chunk, int chunkX, int chunkZ) {
        BlockPos blockPos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
        BiomeData biomeData = NetherEx.BIOME_DATA_MANAGER.getBiomeData(this.world.func_180494_b(blockPos.func_177982_a(16, 0, 16)));
        if (this.generateStructures && biomeData != BiomeData.EMPTY && biomeData.getBiome() == Biomes.field_76778_j) {
            this.netherFortress.func_186125_a(this.world, chunkX, chunkZ, null);
        }
    }
}

