/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.world.biome;

import java.util.Collections;
import logictechcorp.libraryex.world.biome.data.BiomeData;
import logictechcorp.libraryex.world.generation.GenerationStage;
import logictechcorp.libraryex.world.generation.trait.BiomeTrait;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitBigMushroom;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitCluster;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitOre;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitStructure;
import logictechcorp.netherex.NetherEx;
import logictechcorp.netherex.entity.monster.EntitySpore;
import logictechcorp.netherex.entity.monster.EntitySporeCreeper;
import logictechcorp.netherex.entity.neutral.EntityMogus;
import logictechcorp.netherex.init.NetherExBiomes;
import logictechcorp.netherex.init.NetherExBlocks;
import logictechcorp.netherex.world.biome.BiomeNetherEx;
import logictechcorp.netherex.world.generation.trait.BiomeTraitEnoki;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.biome.Biome;

public class BiomeFungiForest
extends BiomeNetherEx {
    private static final IBlockState HYPHAE = NetherExBlocks.HYPHAE.func_176223_P();
    private static final IBlockState LIVELY_NETHERRACK = NetherExBlocks.LIVELY_NETHERRACK.func_176223_P();

    public BiomeFungiForest() {
        super(NetherEx.instance, new Biome.BiomeProperties("Fungi Forest").func_185410_a(1.1f).func_185395_b(0.0f).func_185396_a(), "fungi_forest");
        this.field_76752_A = HYPHAE;
        this.field_76753_B = LIVELY_NETHERRACK;
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityMogus.class, 100, 4, 6));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntitySpore.class, 25, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntitySporeCreeper.class, 50, 1, 4));
    }

    @Override
    public BiomeData getBiomeData() {
        BiomeData biomeData = new BiomeData((Biome)NetherExBiomes.FUNGI_FOREST, 4, true, false);
        biomeData.addBiomeBlock(BiomeData.BlockType.SURFACE_BLOCK, NetherExBlocks.HYPHAE.func_176223_P());
        biomeData.addBiomeBlock(BiomeData.BlockType.SUBSURFACE_BLOCK, LIVELY_NETHERRACK);
        biomeData.addBiomeBlock(BiomeData.BlockType.LIQUID_BLOCK, LAVA);
        biomeData.addBiomeTrait(GenerationStage.DECORATION, (BiomeTrait)BiomeTraitCluster.create(trait -> {
            trait.generationAttempts(10);
            trait.randomizeGenerationAttempts(true);
            trait.minimumGenerationHeight(4);
            trait.maximumGenerationHeight(124);
            trait.blockToAttachTo(Blocks.field_150424_aL.func_176223_P());
            trait.direction(EnumFacing.DOWN);
        }));
        biomeData.addBiomeTrait(GenerationStage.DECORATION, (BiomeTrait)BiomeTraitCluster.create(trait -> {
            trait.generationAttempts(10);
            trait.minimumGenerationHeight(1);
            trait.maximumGenerationHeight(128);
            trait.blockToAttachTo(Blocks.field_150424_aL.func_176223_P());
            trait.direction(EnumFacing.DOWN);
        }));
        biomeData.addBiomeTrait(GenerationStage.DECORATION, (BiomeTrait)BiomeTraitBigMushroom.create(trait -> {
            trait.generationAttempts(256);
            trait.minimumGenerationHeight(32);
            trait.maximumGenerationHeight(108);
            trait.mushroomCap(NetherExBlocks.BROWN_ELDER_MUSHROOM_CAP.func_176223_P());
            trait.mushroomStem(NetherExBlocks.ELDER_MUSHROOM_STEM.func_176223_P());
            trait.blockToPlaceOn(HYPHAE);
            trait.shape(BiomeTraitBigMushroom.Shape.FLAT);
        }));
        biomeData.addBiomeTrait(GenerationStage.DECORATION, (BiomeTrait)BiomeTraitBigMushroom.create(trait -> {
            trait.generationAttempts(256);
            trait.minimumGenerationHeight(32);
            trait.maximumGenerationHeight(108);
            trait.mushroomCap(NetherExBlocks.RED_ELDER_MUSHROOM_CAP.func_176223_P());
            trait.mushroomStem(NetherExBlocks.ELDER_MUSHROOM_STEM.func_176223_P());
            trait.blockToPlaceOn(HYPHAE);
            trait.shape(BiomeTraitBigMushroom.Shape.BULB);
        }));
        biomeData.addBiomeTrait(GenerationStage.DECORATION, (BiomeTrait)BiomeTraitEnoki.create(trait -> {
            trait.generationAttempts(32);
            trait.minimumGenerationHeight(48);
            trait.maximumGenerationHeight(118);
        }));
        biomeData.addBiomeTrait(GenerationStage.ORE, (BiomeTrait)BiomeTraitOre.create(trait -> {
            trait.generationAttempts(16);
            trait.minimumGenerationHeight(10);
            trait.maximumGenerationHeight(108);
            trait.blockToSpawn(NetherExBlocks.QUARTZ_ORE.func_176223_P());
            trait.blockToReplace(Blocks.field_150424_aL.func_176223_P());
            trait.veinSize(14);
        }));
        biomeData.addBiomeTrait(GenerationStage.STRUCTURE, (BiomeTrait)BiomeTraitStructure.create(trait -> {
            trait.generationAttempts(1);
            trait.generationProbability(0.0125);
            trait.minimumGenerationHeight(32);
            trait.maximumGenerationHeight(118);
            trait.structures(Collections.singletonList(NetherEx.getResource("ghast_queen_shrine")));
            trait.structureType(BiomeTraitStructure.StructureType.AIR);
            trait.clearancePercentage(1.0);
        }));
        return biomeData;
    }
}

