/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.village;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.json.JsonFormat;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import logictechcorp.libraryex.trade.Trade;
import logictechcorp.libraryex.utility.FileHelper;
import logictechcorp.libraryex.utility.WorldHelper;
import logictechcorp.netherex.NetherEx;
import logictechcorp.netherex.init.NetherExRegistries;
import logictechcorp.netherex.village.PigtificateProfession;
import logictechcorp.netherex.village.PigtificateVillageData;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.commons.io.FileUtils;

public class PigtificateVillageManager {
    private final Map<PigtificateProfession.Career, List<Trade>> defaultTrades = new HashMap<PigtificateProfession.Career, List<Trade>>();
    private final Map<Integer, PigtificateVillageData> pigtificateVillageData = new HashMap<Integer, PigtificateVillageData>();

    public void setup() {
        NetherExRegistries.PIGTIFICATE_PROFESSIONS.getValuesCollection().forEach(profession -> profession.getCareers().forEach(career -> {
            List cfr_ignored_0 = this.defaultTrades.put((PigtificateProfession.Career)((Object)((Object)career)), new ArrayList(career.getTrades()));
        }));
    }

    public void loadVillageData(WorldEvent.Load event) {
        World world = event.getWorld();
        if (!this.hasData(world)) {
            this.getVillageData(world, false);
        }
    }

    public void unloadVillageData(WorldEvent.Unload event) {
        this.pigtificateVillageData.remove(event.getWorld().field_73011_w.getDimension());
    }

    public void cleanup(WorldEvent.Unload event) {
        NetherExRegistries.PIGTIFICATE_PROFESSIONS.getValuesCollection().forEach(profession -> profession.getCareers().forEach(career -> career.getTrades().forEach(arg_0 -> ((PigtificateProfession.Career)((Object)((Object)career))).removeTrade(arg_0))));
        this.pigtificateVillageData.clear();
    }

    public void readPigtificateTradeConfigs(WorldEvent.Load event) {
        Path path = new File(WorldHelper.getSaveDirectory((World)event.getWorld()), "/config/netherex/pigtificate_trades").toPath();
        NetherEx.LOGGER.info("Reading Pigtificate trade configs.");
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            Iterator pathIter = Files.walk(path, new FileVisitOption[0]).iterator();
            while (pathIter.hasNext()) {
                Path configPath = (Path)pathIter.next();
                File configFile = configPath.toFile();
                if (FileHelper.getFileExtension((File)configFile).equals("json")) {
                    List tradeConfigs;
                    PigtificateProfession.Career career;
                    String fileText = FileUtils.readFileToString((File)configFile, (Charset)Charset.defaultCharset()).trim();
                    if (fileText.isEmpty() || !fileText.startsWith("{") || !fileText.endsWith("}")) {
                        String filePath = configFile.getPath();
                        String fileBackupPath = filePath + "_backup";
                        Files.move(configFile.toPath(), Paths.get(fileBackupPath, new String[0]), new CopyOption[0]);
                        NetherEx.LOGGER.warn("The trade config at {} was invalid and was backed up as {}.", (Object)filePath, (Object)fileBackupPath);
                        continue;
                    }
                    FileConfig config = FileConfig.builder((File)configFile, (ConfigFormat)JsonFormat.fancyInstance()).preserveInsertionOrder().build();
                    config.load();
                    PigtificateProfession profession = (PigtificateProfession)NetherExRegistries.PIGTIFICATE_PROFESSIONS.getValue(new ResourceLocation((String)config.get("profession")));
                    if (profession != null && (career = (PigtificateProfession.Career)profession.getCareer(new ResourceLocation((String)config.get("career")))) != null && (tradeConfigs = (List)config.getOrElse("trades", new ArrayList())).size() > 0) {
                        for (Config tradeConfig : tradeConfigs) {
                            career.addTrade(new Trade(tradeConfig));
                        }
                    }
                    config.save();
                    config.close();
                    continue;
                }
                if (configFile.isDirectory() || FileHelper.getFileExtension((File)configFile).equals("json_backup")) continue;
                NetherEx.LOGGER.warn("Skipping file located at {}, as it is not a json file.", (Object)configPath.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void createPigtificateTradeConfigs(WorldEvent.Load event) {
        try {
            NetherEx.LOGGER.info("Creating Pigtificate trade configs.");
            for (Map.Entry<PigtificateProfession.Career, List<Trade>> entry : this.defaultTrades.entrySet()) {
                PigtificateProfession.Career career = entry.getKey();
                List<Trade> trades = entry.getValue();
                File configFile = new File(WorldHelper.getSaveDirectory((World)event.getWorld()), "/config/netherex/pigtificate_trades/" + career.getName().toString().replace(":", "/") + ".json");
                if (configFile.exists()) continue;
                Files.createDirectories(configFile.getParentFile().toPath(), new FileAttribute[0]);
                FileConfig tradeConfig = FileConfig.of((File)configFile);
                tradeConfig.set("profession", (Object)((PigtificateProfession)career.getProfession()).getName().toString());
                tradeConfig.set("career", (Object)career.getName().toString());
                tradeConfig.add("trades", trades.stream().map(Trade::getAsConfig).collect(Collectors.toList()));
                tradeConfig.save();
                tradeConfig.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean hasData(World world) {
        return this.pigtificateVillageData.containsKey(world.field_73011_w.getDimension());
    }

    public PigtificateVillageData getVillageData(World world, boolean createData) {
        PigtificateVillageData data;
        int dimensionId = world.field_73011_w.getDimension();
        if (this.hasData(world)) {
            data = this.pigtificateVillageData.get(dimensionId);
        } else {
            String worldFile = PigtificateVillageData.getDataId(world);
            data = (PigtificateVillageData)world.getPerWorldStorage().func_75742_a(PigtificateVillageData.class, worldFile);
            if (data == null && createData) {
                data = new PigtificateVillageData(world);
                world.getPerWorldStorage().func_75745_a(worldFile, (WorldSavedData)data);
            }
        }
        if (data != null) {
            data.setWorld(world);
            this.pigtificateVillageData.put(dimensionId, data);
        }
        return data;
    }
}

