/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.entity.neutral;

import logictechcorp.netherex.NetherEx;
import logictechcorp.netherex.entity.ai.EntityAIGoldGolemDefendVillage;
import logictechcorp.netherex.entity.ai.EntityAIGoldGolemLookAtPigtificate;
import logictechcorp.netherex.entity.monster.EntitySporeCreeper;
import logictechcorp.netherex.init.NetherExLootTables;
import logictechcorp.netherex.village.PigtificateVillage;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGoldGolem
extends EntityGolem {
    protected static final DataParameter<Boolean> PLAYER_CREATED = EntityDataManager.func_187226_a(EntityGoldGolem.class, (DataSerializer)DataSerializers.field_187198_h);
    private PigtificateVillage village;
    private int homeCheckTimer;
    private int attackTimer;
    private int flowerHeldCounter;

    public EntityGoldGolem(World world) {
        super(world);
        this.field_70178_ae = true;
        this.func_70105_a(1.4f, 3.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.9, 32.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 0.6, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIGoldGolemLookAtPigtificate(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIGoldGolemDefendVillage(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 10, false, true, entity -> entity != null && IMob.field_175450_e.apply((Object)((EntityLiving)entity)) && !(entity instanceof EntitySporeCreeper)));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PLAYER_CREATED, (Object)false);
    }

    protected void func_70619_bc() {
        if (this.homeCheckTimer-- <= 0) {
            this.homeCheckTimer = 70 + this.field_70146_Z.nextInt(50);
            this.village = NetherEx.PIGTIFICATE_VILLAGE_MANAGER.getVillageData(this.func_130014_f_(), true).getNearestVillage(new BlockPos((Entity)this), 32);
            if (this.village == null) {
                this.func_110177_bN();
            } else {
                BlockPos blockpos = this.village.getCenter();
                this.func_175449_a(blockpos, (int)((float)this.village.getRadius() * 0.6f));
            }
        }
        super.func_70619_bc();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    protected int func_70682_h(int air) {
        return air;
    }

    protected void func_82167_n(Entity entityIn) {
        if (entityIn instanceof IMob && !(entityIn instanceof EntitySporeCreeper) && this.func_70681_au().nextInt(20) == 0) {
            this.func_70624_b((EntityLivingBase)entityIn);
        }
        super.func_82167_n(entityIn);
    }

    public void func_70636_d() {
        int posZ;
        int posY;
        int posX;
        IBlockState state;
        super.func_70636_d();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.flowerHeldCounter > 0) {
            --this.flowerHeldCounter;
        }
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 2.500000277905201E-7 && this.field_70146_Z.nextInt(5) == 0 && (state = this.field_70170_p.func_180495_p(new BlockPos(posX = MathHelper.func_76128_c((double)this.field_70165_t), posY = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), posZ = MathHelper.func_76128_c((double)this.field_70161_v)))).func_185904_a() != Material.field_151579_a) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)state)});
        }
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        return (!this.isPlayerCreated() || !EntityPlayer.class.isAssignableFrom(cls)) && cls != EntitySporeCreeper.class && super.func_70686_a(cls);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("PlayerCreated", this.isPlayerCreated());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setPlayerCreated(compound.func_74767_n("PlayerCreated"));
    }

    public boolean func_70652_k(Entity entity) {
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        boolean attack = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(7 + this.field_70146_Z.nextInt(15)));
        if (attack) {
            entity.field_70181_x += (double)0.4f;
            this.func_174815_a((EntityLivingBase)this, entity);
        }
        this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        return attack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
            this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        } else if (id == 11) {
            this.flowerHeldCounter = 400;
        } else if (id == 34) {
            this.flowerHeldCounter = 0;
        } else {
            super.func_70103_a(id);
        }
    }

    public PigtificateVillage getVillage() {
        return this.village;
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public void setHoldingFlower(boolean holding) {
        if (holding) {
            this.flowerHeldCounter = 400;
            this.field_70170_p.func_72960_a((Entity)this, (byte)11);
        } else {
            this.flowerHeldCounter = 0;
            this.field_70170_p.func_72960_a((Entity)this, (byte)34);
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187602_cF;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187599_cE;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 1.0f);
    }

    protected ResourceLocation func_184647_J() {
        return NetherExLootTables.GOLD_GOLEM;
    }

    public int getFlowerHeldCounter() {
        return this.flowerHeldCounter;
    }

    public boolean isPlayerCreated() {
        return (Boolean)this.field_70180_af.func_187225_a(PLAYER_CREATED);
    }

    public void setPlayerCreated(boolean playerCreated) {
        this.field_70180_af.func_187227_b(PLAYER_CREATED, (Object)playerCreated);
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.isPlayerCreated() && this.field_70717_bb != null && this.village != null) {
            this.village.modifyPlayerReputation(this.field_70717_bb.func_110124_au(), -5);
        }
        super.func_70645_a(cause);
    }
}

