/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.block;

import java.util.Random;
import logictechcorp.libraryex.block.BlockMod;
import logictechcorp.libraryex.block.property.BlockProperties;
import logictechcorp.libraryex.utility.RandomHelper;
import logictechcorp.netherex.NetherEx;
import logictechcorp.netherex.handler.ConfigHandler;
import logictechcorp.netherex.init.NetherExMobEffects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBlueFire
extends BlockMod {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)15);
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool UPPER = PropertyBool.func_177716_a((String)"up");

    public BlockBlueFire() {
        super(NetherEx.getResource("blue_fire"), new BlockProperties(Material.field_151581_o, MapColor.field_151674_s).lightLevel(1.0f).tickRandomly());
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(false)));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random random) {
        block12: {
            block11: {
                double posZ;
                double posY;
                double posX;
                int i;
                if (random.nextInt(24) == 0) {
                    world.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f + random.nextFloat(), random.nextFloat() * 0.7f + 0.3f, false);
                }
                if (world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) || this.canCatchFire((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP)) break block11;
                if (this.canCatchFire((IBlockAccess)world, pos.func_177976_e(), EnumFacing.EAST)) {
                    for (i = 0; i < 2; ++i) {
                        posX = (double)pos.func_177958_n() + random.nextDouble() * (double)0.1f;
                        posY = (double)pos.func_177956_o() + random.nextDouble();
                        posZ = (double)pos.func_177952_p() + random.nextDouble();
                        world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, posX, posY, posZ, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
                if (this.canCatchFire((IBlockAccess)world, pos.func_177974_f(), EnumFacing.WEST)) {
                    for (i = 0; i < 2; ++i) {
                        posX = (double)(pos.func_177958_n() + 1) - random.nextDouble() * (double)0.1f;
                        posY = (double)pos.func_177956_o() + random.nextDouble();
                        posZ = (double)pos.func_177952_p() + random.nextDouble();
                        world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, posX, posY, posZ, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
                if (this.canCatchFire((IBlockAccess)world, pos.func_177978_c(), EnumFacing.SOUTH)) {
                    for (i = 0; i < 2; ++i) {
                        posX = (double)pos.func_177958_n() + random.nextDouble();
                        posY = (double)pos.func_177956_o() + random.nextDouble();
                        posZ = (double)pos.func_177952_p() + random.nextDouble() * (double)0.1f;
                        world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, posX, posY, posZ, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
                if (this.canCatchFire((IBlockAccess)world, pos.func_177968_d(), EnumFacing.NORTH)) {
                    for (i = 0; i < 2; ++i) {
                        posX = (double)pos.func_177958_n() + random.nextDouble();
                        posY = (double)pos.func_177956_o() + random.nextDouble();
                        posZ = (double)(pos.func_177952_p() + 1) - random.nextDouble() * (double)0.1f;
                        world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, posX, posY, posZ, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
                if (!this.canCatchFire((IBlockAccess)world, pos.func_177984_a(), EnumFacing.DOWN)) break block12;
                for (i = 0; i < 2; ++i) {
                    posX = (double)pos.func_177958_n() + random.nextDouble();
                    posY = (double)(pos.func_177956_o() + 1) - random.nextDouble() * (double)0.1f;
                    posZ = (double)pos.func_177952_p() + random.nextDouble();
                    world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, posX, posY, posZ, 0.0, 0.0, 0.0, new int[0]);
                }
                break block12;
            }
            for (int i = 0; i < 3; ++i) {
                double posX = (double)pos.func_177958_n() + random.nextDouble();
                double posY = (double)pos.func_177956_o() + random.nextDouble() * 0.5 + 0.5;
                double posZ = (double)pos.func_177952_p() + random.nextDouble();
                world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, posX, posY, posZ, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149703_v() {
        return false;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149698_L() {
        return false;
    }

    public int func_149738_a(World world) {
        return 15;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (world.func_82736_K().func_82766_b("doFireTick")) {
            if (!this.func_176196_c(world, pos)) {
                world.func_175698_g(pos);
            }
            BlockPos downPos = pos.func_177977_b();
            boolean isFireSource = world.func_180495_p(downPos).func_177230_c().isFireSource(world, pos.func_177977_b(), EnumFacing.UP);
            int age = (Integer)state.func_177229_b((IProperty)AGE);
            if (!isFireSource && world.func_72896_J() && this.isBeingRainedOn(world, pos) && age > 0 && random.nextFloat() < 0.2f + (float)age * 0.03f) {
                world.func_175698_g(pos);
            } else {
                if (age > 0 && age < 15) {
                    state = state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age + random.nextInt(3) / 2));
                    world.func_180501_a(pos, state, 4);
                }
                world.func_175684_a(pos, (Block)this, this.func_149738_a(world) + random.nextInt(10));
                if (!isFireSource) {
                    if (!this.canNeighborCatchFire(world, pos)) {
                        if (!world.func_180495_p(downPos).isSideSolid((IBlockAccess)world, downPos, EnumFacing.UP) || age > 3) {
                            world.func_175698_g(pos);
                        }
                        return;
                    }
                    if (!this.canCatchFire((IBlockAccess)world, downPos, EnumFacing.UP) && age == 15 && random.nextInt(4) == 0) {
                        world.func_175698_g(pos);
                        return;
                    }
                }
                boolean highHumidity = world.func_180502_D(pos);
                int humidityChance = 0;
                if (highHumidity) {
                    humidityChance = -50;
                }
                this.tryCatchFire(world, pos, 300 + humidityChance, random, age, EnumFacing.WEST);
                this.tryCatchFire(world, pos, 300 + humidityChance, random, age, EnumFacing.EAST);
                this.tryCatchFire(world, pos, 250 + humidityChance, random, age, EnumFacing.UP);
                this.tryCatchFire(world, pos, 250 + humidityChance, random, age, EnumFacing.DOWN);
                this.tryCatchFire(world, pos, 300 + humidityChance, random, age, EnumFacing.SOUTH);
                this.tryCatchFire(world, pos, 300 + humidityChance, random, age, EnumFacing.NORTH);
                for (int posX = -1; posX <= 1; ++posX) {
                    for (int posZ = -1; posZ <= 1; ++posZ) {
                        for (int posY = -1; posY <= 4; ++posY) {
                            BlockPos blockPos;
                            int encouragement;
                            if (posX == 0 && posY == 0 && posZ == 0) continue;
                            int fireHeightChance = 100;
                            if (posY > 1) {
                                fireHeightChance += (posY - 1) * 100;
                            }
                            if ((encouragement = this.getNeighborEncouragement(world, blockPos = pos.func_177982_a(posX, posY, posZ))) <= 0) continue;
                            int fireHumidityChance = (encouragement + 40 + world.func_175659_aa().func_151525_a() * 7) / (age + 30);
                            if (highHumidity) {
                                fireHumidityChance /= 2;
                            }
                            if (fireHumidityChance <= 0 || random.nextInt(fireHeightChance) > fireHumidityChance || world.func_72896_J() && this.isBeingRainedOn(world, blockPos)) continue;
                            int newAge = age + 1;
                            if (newAge > 15) {
                                newAge = 15;
                            }
                            world.func_180501_a(blockPos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(newAge)), 3);
                        }
                    }
                }
            }
        }
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) || this.canNeighborCatchFire(world, pos);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) && !this.canNeighborCatchFire(world, pos)) {
            world.func_175698_g(pos);
        } else {
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world) + world.field_73012_v.nextInt(10));
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) && !this.canNeighborCatchFire(world, pos)) {
            world.func_175698_g(pos);
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityItem) {
            entity.func_70106_y();
        } else if (entity instanceof EntityLivingBase && !entity.func_70045_F()) {
            if (ConfigHandler.blockConfig.blueFire.minEntityTicksAlight > ConfigHandler.blockConfig.blueFire.maxEntityTicksAlight) {
                int temp = ConfigHandler.blockConfig.blueFire.minEntityTicksAlight;
                ConfigHandler.blockConfig.blueFire.minEntityTicksAlight = ConfigHandler.blockConfig.blueFire.maxEntityTicksAlight;
                ConfigHandler.blockConfig.blueFire.maxEntityTicksAlight = temp;
            }
            int ticks = RandomHelper.getNumberInRange((int)ConfigHandler.blockConfig.blueFire.minEntityTicksAlight, (int)ConfigHandler.blockConfig.blueFire.maxEntityTicksAlight, (Random)world.field_73012_v);
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(NetherExMobEffects.FIRE_BURNING, ticks));
        }
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (!world.func_180495_p(pos.func_177977_b()).isSideSolid(world, pos.func_177977_b(), EnumFacing.UP) && !this.canCatchFire(world, pos.func_177977_b(), EnumFacing.UP)) {
            return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canCatchFire(world, pos.func_177978_c(), EnumFacing.SOUTH))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canCatchFire(world, pos.func_177974_f(), EnumFacing.WEST))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canCatchFire(world, pos.func_177968_d(), EnumFacing.NORTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canCatchFire(world, pos.func_177976_e(), EnumFacing.EAST))).func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(this.canCatchFire(world, pos.func_177984_a(), EnumFacing.DOWN)));
        }
        return this.func_176223_P();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE, NORTH, EAST, SOUTH, WEST, UPPER});
    }

    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return PathNodeType.DAMAGE_FIRE;
    }

    private boolean canCatchFire(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return world.func_180495_p(pos).func_177230_c().isFlammable(world, pos, face);
    }

    private boolean canNeighborCatchFire(World world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.values()) {
            if (!this.canCatchFire((IBlockAccess)world, pos.func_177972_a(facing), facing.func_176734_d())) continue;
            return true;
        }
        return false;
    }

    private int getNeighborEncouragement(World world, BlockPos pos) {
        if (!world.func_175623_d(pos)) {
            return 0;
        }
        int encouragement = 0;
        for (EnumFacing facing : EnumFacing.values()) {
            encouragement = Math.max(world.func_180495_p(pos.func_177972_a(facing)).func_177230_c().getFireSpreadSpeed((IBlockAccess)world, pos.func_177972_a(facing), facing.func_176734_d()), encouragement);
        }
        return encouragement;
    }

    private void tryCatchFire(World world, BlockPos pos, int chance, Random random, int age, EnumFacing face) {
        BlockPos targetPos = pos.func_177972_a(face.func_176734_d());
        int flammability = world.func_180495_p(targetPos).func_177230_c().getFlammability((IBlockAccess)world, targetPos, face);
        if (random.nextInt(chance) < flammability) {
            IBlockState state = world.func_180495_p(targetPos);
            if (random.nextInt(age + 10) < 5) {
                int newAge = age + 1;
                if (newAge > 15) {
                    newAge = 15;
                }
                world.func_180501_a(targetPos, this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(newAge)), 3);
            } else if (age > 0) {
                world.func_175698_g(pos);
            }
            if (state.func_177230_c() == Blocks.field_150335_W) {
                Blocks.field_150335_W.func_176206_d(world, targetPos, state.func_177226_a((IProperty)BlockTNT.field_176246_a, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    private boolean isBeingRainedOn(World world, BlockPos pos) {
        return world.func_175727_C(pos) || world.func_175727_C(pos.func_177976_e()) || world.func_175727_C(pos.func_177974_f()) || world.func_175727_C(pos.func_177978_c()) || world.func_175727_C(pos.func_177968_d());
    }
}

