/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import logictechcorp.libraryex.IModData;
import logictechcorp.libraryex.LibraryEx;
import logictechcorp.libraryex.proxy.IProxy;
import logictechcorp.libraryex.world.biome.data.BiomeDataManager;
import logictechcorp.netherex.handler.ConfigHandler;
import logictechcorp.netherex.handler.IMCHandler;
import logictechcorp.netherex.init.NetherExBiomes;
import logictechcorp.netherex.init.NetherExCriteria;
import logictechcorp.netherex.init.NetherExDataFixers;
import logictechcorp.netherex.init.NetherExOreDictionary;
import logictechcorp.netherex.init.NetherExOverrides;
import logictechcorp.netherex.init.NetherExPigtificates;
import logictechcorp.netherex.init.NetherExRecipes;
import logictechcorp.netherex.village.PigtificateVillageManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="netherex", name="NetherEx", version="2.1.5", dependencies="required-after:libraryex@[1.1.1,);", acceptedMinecraftVersions="[1.12.2]")
public class NetherEx
implements IModData {
    public static final String MOD_ID = "netherex";
    public static final String NAME = "NetherEx";
    public static final String VERSION = "2.1.5";
    public static final String DEPENDENCIES = "required-after:libraryex@[1.1.1,);";
    public static final boolean BIOMES_O_PLENTY_LOADED = Loader.isModLoaded((String)"biomesoplenty");
    @Mod.Instance(value="netherex")
    public static NetherEx instance;
    @SidedProxy(clientSide="logictechcorp.netherex.proxy.ClientProxy", serverSide="logictechcorp.netherex.proxy.ServerProxy")
    public static IProxy proxy;
    private static final CreativeTabs CREATIVE_TAB;
    public static final BiomeDataManager BIOME_DATA_MANAGER;
    public static final PigtificateVillageManager PIGTIFICATE_VILLAGE_MANAGER;
    public static final Logger LOGGER;

    @Mod.EventHandler
    public void onFMLPreInitialization(FMLPreInitializationEvent event) {
        NetherExOverrides.overrideObjects();
        proxy.preInit();
    }

    @Mod.EventHandler
    public void onFMLInitialization(FMLInitializationEvent event) {
        NetherExDataFixers.registerFixes();
        NetherExPigtificates.registerPigtificateCareers();
        NetherExBiomes.registerBiomeTypes();
        if (ConfigHandler.dimensionConfig.nether.overrideNether) {
            NetherExBiomes.registerBiomeData();
        }
        NetherExRecipes.registerRecipes();
        NetherExOreDictionary.registerOres();
        NetherExCriteria.registerCriteria();
        IMCHandler.sendCompatibilityMessages();
        proxy.init();
    }

    @Mod.EventHandler
    public void onFMLPostInitialization(FMLPostInitializationEvent event) {
        if (ConfigHandler.dimensionConfig.nether.overrideNether) {
            BIOME_DATA_MANAGER.setup();
        }
        PIGTIFICATE_VILLAGE_MANAGER.setup();
        proxy.postInit();
    }

    @Mod.EventHandler
    public void onFMLServerStarting(FMLServerStartingEvent event) {
        if (ConfigHandler.dimensionConfig.nether.overrideNether) {
            NetherExOverrides.overrideNether();
        }
    }

    public String getModId() {
        return MOD_ID;
    }

    public CreativeTabs getCreativeTab() {
        return CREATIVE_TAB;
    }

    public static ResourceLocation getResource(String name) {
        return new ResourceLocation("netherex:" + name);
    }

    static {
        CREATIVE_TAB = new CreativeTabs(MOD_ID){

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_78016_d() {
                return new ItemStack(Blocks.field_150424_aL);
            }
        };
        BIOME_DATA_MANAGER = new BiomeDataManager(MOD_ID, NAME);
        PIGTIFICATE_VILLAGE_MANAGER = new PigtificateVillageManager();
        LOGGER = LogManager.getLogger((String)NAME);
        FluidRegistry.enableUniversalBucket();
        File oldConfigDirectory = new File(LibraryEx.CONFIG_DIRECTORY, NAME);
        try {
            if (oldConfigDirectory.exists() && oldConfigDirectory.getCanonicalFile().getName().equals(NAME)) {
                Files.move(oldConfigDirectory.toPath(), new File(LibraryEx.CONFIG_DIRECTORY, "NetherEx_old").toPath(), new CopyOption[0]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

