/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.ping.data;

import dmillerw.ping.data.PingType;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class PingWrapper {
    public final BlockPos pos;
    public final int color;
    public final PingType type;
    public boolean isOffscreen = false;
    public float screenX;
    public float screenY;
    public int animationTimer = 20;
    public int timer;

    public static PingWrapper readFromBuffer(ByteBuf buffer) {
        int x = buffer.readInt();
        int y = buffer.readInt();
        int z = buffer.readInt();
        int color = buffer.readInt();
        PingType type = PingType.values()[buffer.readInt()];
        return new PingWrapper(new BlockPos(x, y, z), color, type);
    }

    public PingWrapper(BlockPos pos, int color, PingType type) {
        this.pos = pos;
        this.color = color;
        this.type = type;
    }

    public AxisAlignedBB getAABB() {
        return new AxisAlignedBB((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5, (double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5);
    }

    public void writeToBuffer(ByteBuf buffer) {
        buffer.writeInt(this.pos.func_177958_n());
        buffer.writeInt(this.pos.func_177956_o());
        buffer.writeInt(this.pos.func_177952_p());
        buffer.writeInt(this.color);
        buffer.writeInt(this.type.ordinal());
    }
}

