/*
 * Decompiled with CFR 0.152.
 */
package panda.birdsnests;

import net.minecraft.block.properties.PropertyBool;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import panda.birdsnests.DecayLeafEventHandler;
import panda.birdsnests.HarvestLeafEventHandler;
import panda.birdsnests.ItemNest;

@Mod(modid="birdsnests", name="Bird's Nests", version="2.1.0", acceptedMinecraftVersions="[1.12.2]")
public class BirdsNests {
    public static final String MODID = "birdsnests";
    public static final String NAME = "Bird's Nests";
    public static final String VERSION = "2.1.0";
    public static int nestRarity;
    public static boolean use32;
    public static boolean allowStacking;
    public static float decayDropModifier;
    public static boolean allowDecayDrops;
    public static PropertyBool DECAYABLE;
    public static Item nest;
    @Mod.Instance(value="birdsnests")
    public static BirdsNests instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(MODID, "nest_loot"));
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        nestRarity = config.getInt("NEST_DROP_RARITY", "general", 40, 0, 1000, "");
        use32 = config.getBoolean("USE32_TEXTURE", "general", false, "");
        allowStacking = config.getBoolean("ALLOW_STACKING", "general", false, "Allows to enable/disable nests stacking");
        decayDropModifier = config.getFloat("NEST_DECAY_DROP_MULTIPLIER", "general", 1.25f, 0.0f, 1000.0f, "This makes nests more (or less ) rare from decaying leaves. Leave at 1 for no change.");
        allowDecayDrops = config.getBoolean("ALLOW_DECAY_DROPS", "general", true, "Allows to enable/disable nests dropping from decaying leaves");
        config.save();
        nest = new ItemNest();
        if (!allowStacking) {
            nest.func_77625_d(1);
        }
        nest.func_77655_b("birdsnest");
        ForgeRegistries.ITEMS.register(nest.setRegistryName("birdsnest"));
        MinecraftForge.EVENT_BUS.register((Object)new HarvestLeafEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new DecayLeafEventHandler());
        if (event.getSide() == Side.CLIENT) {
            ModelResourceLocation itemModelResourceLocation = new ModelResourceLocation("birdsnests:birdsnest", "inventory");
            ModelResourceLocation itemModelResourceLocation32 = new ModelResourceLocation("birdsnests:birdsnest32", "inventory");
            ModelBakery.registerItemVariants((Item)nest, (ResourceLocation[])new ResourceLocation[]{itemModelResourceLocation, itemModelResourceLocation32});
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (event.getSide() == Side.CLIENT) {
            ModelResourceLocation itemModelResourceLocation = new ModelResourceLocation("birdsnests:birdsnest", "inventory");
            ModelResourceLocation itemModelResourceLocation32 = new ModelResourceLocation("birdsnests:birdsnest32", "inventory");
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(nest, 0, itemModelResourceLocation);
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(nest, 1, itemModelResourceLocation32);
        }
    }

    static {
        DECAYABLE = PropertyBool.func_177716_a((String)"decayable");
    }
}

