/*
 * Decompiled with CFR 0.152.
 */
package com.ochotonida.candymod.world.worldgen;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenBiomeSpikes
extends WorldGenerator {
    public final Biome biome;
    public int maxLength;
    public int minLength;
    public int chance;
    public List<IBlockState> stateList;

    public WorldGenBiomeSpikes(Biome biome, int minLength, int maxLength, int chance, IBlockState ... states) {
        this.biome = biome;
        if (maxLength <= minLength) {
            throw new IllegalArgumentException();
        }
        this.chance = chance;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.stateList = Arrays.asList(states);
        if (this.stateList.size() < 1) {
            throw new IllegalArgumentException();
        }
    }

    public IBlockState getRandomState(Random rand) {
        if (this.stateList.size() == 1) {
            return this.stateList.get(0);
        }
        return this.stateList.get(rand.nextInt(this.stateList.size()));
    }

    @ParametersAreNonnullByDefault
    public boolean func_180709_b(World worldIn, Random rand, BlockPos pos) {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                BlockPos blockpos = pos.func_177982_a(i + 8, 255, j + 8);
                if (worldIn.func_180494_b(blockpos) != this.biome) continue;
                int blocksToPlace = 0;
                IBlockState state = this.getRandomState(rand);
                for (int k = 255; k >= 0; --k) {
                    if (worldIn.func_180495_p(blockpos).func_177230_c() == this.biome.field_76752_A.func_177230_c() && rand.nextInt(this.chance) == 0) {
                        blocksToPlace = rand.nextInt(this.maxLength + 1 - this.minLength) + this.minLength;
                        state = this.getRandomState(rand);
                    } else if (blocksToPlace > 0 && worldIn.func_180495_p(blockpos).func_177230_c() != this.biome.field_76753_B.func_177230_c()) {
                        this.func_175903_a(worldIn, blockpos, state);
                        --blocksToPlace;
                    }
                    blockpos = blockpos.func_177977_b();
                }
            }
        }
        return true;
    }
}

