/*
 * Decompiled with CFR 0.152.
 */
package com.ochotonida.candymod.world.dimension;

import com.ochotonida.candymod.ModBiomes;
import com.ochotonida.candymod.world.dimension.layer.GenLayerCandyWorldBiome;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerFuzzyZoom;
import net.minecraft.world.gen.layer.GenLayerIsland;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.GenLayerZoom;
import net.minecraft.world.storage.WorldInfo;

public class BiomeProviderCandyWorld
extends BiomeProvider {
    public BiomeProviderCandyWorld(WorldInfo worldInfo) {
        super(worldInfo);
        this.func_76932_a().clear();
        this.func_76932_a().add(ModBiomes.BIOME_CHOCOLATE);
        this.func_76932_a().add(ModBiomes.BIOME_COTTON_CANDY);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public GenLayer[] getModdedBiomeGenerators(WorldType worldType, long seed, GenLayer[] original) {
        original = this.initializeGenLayers(seed, worldType);
        return super.getModdedBiomeGenerators(worldType, seed, original);
    }

    private GenLayer[] initializeGenLayers(long seed, WorldType worldType) {
        int biomeSize = GenLayer.getModdedBiomeSize((WorldType)worldType, (int)((byte)(worldType == WorldType.field_77135_d ? 7 : 5)));
        Object genLayer = new GenLayerIsland(1L);
        genLayer = new GenLayerFuzzyZoom(2000L, (GenLayer)genLayer);
        genLayer = new GenLayerCandyWorldBiome(100L, (GenLayer)genLayer);
        genLayer = GenLayerZoom.func_75915_a((long)2000L, (GenLayer)genLayer, (int)1);
        genLayer = GenLayerZoom.func_75915_a((long)2100L, (GenLayer)genLayer, (int)biomeSize);
        GenLayerVoronoiZoom indexLayer = new GenLayerVoronoiZoom(10L, (GenLayer)genLayer);
        indexLayer.func_75905_a(seed);
        genLayer.func_75905_a(seed);
        return new GenLayer[]{genLayer, indexLayer, genLayer};
    }
}

