/*
 * Decompiled with CFR 0.152.
 */
package com.ochotonida.candymod.world.biome;

import com.ochotonida.candymod.ModBlocks;
import com.ochotonida.candymod.world.biome.DecoratorBase;
import com.ochotonida.candymod.world.dimension.WorldProviderCandyWorld;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.ChunkPrimer;

public abstract class ModBiome
extends Biome {
    public ModBiome(Biome.BiomeProperties properties) {
        super(properties);
        this.initSpawnList();
    }

    public abstract void initSpawnList();

    @Nonnull
    public BiomeDecorator func_76729_a() {
        return new DecoratorBase();
    }

    @ParametersAreNonnullByDefault
    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        if (worldIn.field_73011_w instanceof WorldProviderCandyWorld) {
            this.generateCustomBiomeTerrain(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
        } else {
            this.func_180628_b(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
        }
    }

    public void generateCustomBiomeTerrain(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        int i = worldIn.func_181545_F();
        IBlockState iblockstate = this.field_76752_A;
        IBlockState iblockstate1 = this.field_76753_B;
        int j = -1;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int l = x & 0xF;
        int i1 = z & 0xF;
        for (int j1 = 255; j1 >= 0; --j1) {
            if (j1 <= rand.nextInt(5)) {
                chunkPrimerIn.func_177855_a(i1, j1, l, field_185367_c);
                continue;
            }
            IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(i1, j1, l);
            if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                j = -1;
                continue;
            }
            if (iblockstate2.func_177230_c() != ModBlocks.SUGAR_BLOCK) continue;
            if (j == -1) {
                if (k <= 0) {
                    iblockstate = field_185366_b;
                    iblockstate1 = ModBlocks.SUGAR_BLOCK.func_176223_P();
                } else if (j1 >= i - 4 && j1 <= i + 1) {
                    iblockstate = this.field_76752_A;
                    iblockstate1 = this.field_76753_B;
                }
                if (j1 < i && (iblockstate == null || iblockstate.func_185904_a() == Material.field_151579_a)) {
                    iblockstate = worldIn.field_73011_w instanceof WorldProviderCandyWorld ? ModBlocks.LIQUID_CHOCOLATE_BLOCK.func_176223_P() : field_185372_h;
                }
                j = k;
                if (j1 >= i - 1) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate);
                    continue;
                }
                if (j1 < i - 7 - k) {
                    iblockstate = field_185366_b;
                    iblockstate1 = field_185365_a;
                    chunkPrimerIn.func_177855_a(i1, j1, l, field_185368_d);
                    continue;
                }
                chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate1);
                continue;
            }
            if (j <= 0) continue;
            --j;
            chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate1);
        }
    }
}

