/*
 * Decompiled with CFR 0.152.
 */
package com.ochotonida.candymod.world.biome;

import com.google.common.base.Predicate;
import com.ochotonida.candymod.ModBlocks;
import com.ochotonida.candymod.block.ModBlockProperties;
import com.ochotonida.candymod.enums.EnumChocolate;
import com.ochotonida.candymod.world.dimension.WorldProviderCandyWorld;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class DecoratorBase
extends BiomeDecorator {
    @Nullable
    protected WorldGenerator soilMilkGen;
    @Nullable
    protected WorldGenerator soilWhiteGen;
    @Nullable
    protected WorldGenerator soilDarkGen;
    @Nullable
    protected WorldGenerator chocolateBlockGen;
    @Nullable
    protected WorldGenerator spikesGen;
    protected WorldGenerator sugarBlockGen;
    protected WorldGenerator cookieGen;
    protected WorldGenerator teleporterGen;
    protected WorldGenerator sugarSandGen;

    @ParametersAreNonnullByDefault
    public void func_180292_a(World worldIn, Random random, Biome biome, BlockPos pos) {
        if (this.field_185425_a) {
            throw new RuntimeException("Already decorating");
        }
        this.field_180293_d = ChunkGeneratorSettings.Factory.func_177865_a((String)worldIn.func_72912_H().func_82571_y()).func_177864_b();
        this.field_180294_c = pos;
        if (worldIn.field_73011_w instanceof WorldProviderCandyWorld) {
            this.initDimensionWorldGens();
        } else {
            this.initOverworldWorldGens();
        }
        this.func_150513_a(biome, worldIn, random);
        this.field_185425_a = false;
    }

    protected void initDimensionWorldGens() {
        this.soilMilkGen = new WorldGenMinable(ModBlocks.CANDY_SOIL.func_176223_P().func_177226_a(ModBlockProperties.CHOCOLATE_TYPE, (Comparable)((Object)EnumChocolate.MILK)), 25, (Predicate)BlockMatcher.func_177642_a((Block)ModBlocks.SUGAR_BLOCK));
        this.soilWhiteGen = new WorldGenMinable(ModBlocks.CANDY_SOIL.func_176223_P().func_177226_a(ModBlockProperties.CHOCOLATE_TYPE, (Comparable)((Object)EnumChocolate.WHITE)), 25, (Predicate)BlockMatcher.func_177642_a((Block)ModBlocks.SUGAR_BLOCK));
        this.soilDarkGen = new WorldGenMinable(ModBlocks.CANDY_SOIL.func_176223_P().func_177226_a(ModBlockProperties.CHOCOLATE_TYPE, (Comparable)((Object)EnumChocolate.DARK)), 25, (Predicate)BlockMatcher.func_177642_a((Block)ModBlocks.SUGAR_BLOCK));
        this.sugarBlockGen = new WorldGenMinable(ModBlocks.SUGAR_BLOCK.func_176223_P(), 0);
        this.cookieGen = new WorldGenMinable(ModBlocks.COOKIE_ORE.func_176223_P().func_177226_a((IProperty)ModBlockProperties.IS_SUGAR_VARIANT, (Comparable)Boolean.valueOf(true)), 3, (Predicate)BlockMatcher.func_177642_a((Block)ModBlocks.SUGAR_BLOCK));
        this.teleporterGen = new TeleporterOreGenerator();
        this.sugarSandGen = new WorldGenMinable(ModBlocks.SUGAR_SAND.func_176223_P(), 20, (Predicate)BlockMatcher.func_177642_a((Block)ModBlocks.SUGAR_BLOCK));
        this.field_76821_k = new WorldGenMinable(Blocks.field_150365_q.func_176223_P(), 0);
        this.field_76818_l = new WorldGenMinable(Blocks.field_150366_p.func_176223_P(), 0);
        this.field_76819_m = new WorldGenMinable(Blocks.field_150352_o.func_176223_P(), 0);
        this.field_180299_p = new WorldGenMinable(Blocks.field_150450_ax.func_176223_P(), 0);
        this.field_180298_q = new WorldGenMinable(Blocks.field_150482_ag.func_176223_P(), 0);
        this.field_76831_p = new WorldGenMinable(Blocks.field_150369_x.func_176223_P(), 0);
    }

    protected void initOverworldWorldGens() {
        this.soilMilkGen = new WorldGenMinable(ModBlocks.CANDY_SOIL.func_176223_P().func_177226_a(ModBlockProperties.CHOCOLATE_TYPE, (Comparable)((Object)EnumChocolate.MILK)), 25);
        this.soilWhiteGen = new WorldGenMinable(ModBlocks.CANDY_SOIL.func_176223_P().func_177226_a(ModBlockProperties.CHOCOLATE_TYPE, (Comparable)((Object)EnumChocolate.WHITE)), 25);
        this.soilDarkGen = new WorldGenMinable(ModBlocks.CANDY_SOIL.func_176223_P().func_177226_a(ModBlockProperties.CHOCOLATE_TYPE, (Comparable)((Object)EnumChocolate.DARK)), 25);
        this.sugarBlockGen = new WorldGenMinable(ModBlocks.SUGAR_BLOCK.func_176223_P(), 20);
        this.cookieGen = new WorldGenMinable(ModBlocks.COOKIE_ORE.func_176223_P(), 3);
        this.sugarSandGen = new WorldGenMinable(ModBlocks.SUGAR_SAND.func_176223_P(), 30);
        this.field_76821_k = new WorldGenMinable(Blocks.field_150365_q.func_176223_P(), this.field_180293_d.field_177844_ac);
        this.field_76818_l = new WorldGenMinable(Blocks.field_150366_p.func_176223_P(), this.field_180293_d.field_177848_ag);
        this.field_76819_m = new WorldGenMinable(Blocks.field_150352_o.func_176223_P(), this.field_180293_d.field_177828_ak);
        this.field_180299_p = new WorldGenMinable(Blocks.field_150450_ax.func_176223_P(), this.field_180293_d.field_177836_ao);
        this.field_180298_q = new WorldGenMinable(Blocks.field_150482_ag.func_176223_P(), this.field_180293_d.field_177814_as);
        this.field_76831_p = new WorldGenMinable(Blocks.field_150369_x.func_176223_P(), this.field_180293_d.field_177822_aw);
    }

    @ParametersAreNonnullByDefault
    protected void func_150513_a(Biome biome, World worldIn, Random rand) {
        if (this.spikesGen != null && TerrainGen.decorate((World)worldIn, (Random)rand, (BlockPos)this.field_180294_c, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CUSTOM)) {
            this.spikesGen.func_180709_b(worldIn, rand, this.field_180294_c);
        }
        super.func_150513_a(biome, worldIn, rand);
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (BlockPos)this.field_180294_c, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CUSTOM)) {
            this.genBiomeDecorations(worldIn, rand);
        }
    }

    @ParametersAreNonnullByDefault
    protected void genBiomeDecorations(World worldIn, Random rand) {
    }

    @ParametersAreNonnullByDefault
    protected void func_76797_b(World worldIn, Random rand) {
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Pre(worldIn, rand, this.field_180294_c));
        this.generateCustomOres(worldIn, rand);
        if (!(worldIn.field_73011_w instanceof WorldProviderCandyWorld)) {
            if (TerrainGen.generateOre((World)worldIn, (Random)rand, (WorldGenerator)this.field_76821_k, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.COAL)) {
                this.func_76795_a(worldIn, rand, this.field_180293_d.field_177845_ad, this.field_76821_k, this.field_180293_d.field_177851_ae, this.field_180293_d.field_177853_af);
            }
            if (TerrainGen.generateOre((World)worldIn, (Random)rand, (WorldGenerator)this.field_76818_l, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.IRON)) {
                this.func_76795_a(worldIn, rand, this.field_180293_d.field_177849_ah, this.field_76818_l, this.field_180293_d.field_177832_ai, this.field_180293_d.field_177834_aj);
            }
            if (TerrainGen.generateOre((World)worldIn, (Random)rand, (WorldGenerator)this.field_76819_m, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.GOLD)) {
                this.func_76795_a(worldIn, rand, this.field_180293_d.field_177830_al, this.field_76819_m, this.field_180293_d.field_177840_am, this.field_180293_d.field_177842_an);
            }
            if (TerrainGen.generateOre((World)worldIn, (Random)rand, (WorldGenerator)this.field_180299_p, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.REDSTONE)) {
                this.func_76795_a(worldIn, rand, this.field_180293_d.field_177838_ap, this.field_180299_p, this.field_180293_d.field_177818_aq, this.field_180293_d.field_177816_ar);
            }
            if (TerrainGen.generateOre((World)worldIn, (Random)rand, (WorldGenerator)this.field_180298_q, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.DIAMOND)) {
                this.func_76795_a(worldIn, rand, this.field_180293_d.field_177812_at, this.field_180298_q, this.field_180293_d.field_177826_au, this.field_180293_d.field_177824_av);
            }
            if (TerrainGen.generateOre((World)worldIn, (Random)rand, (WorldGenerator)this.field_76831_p, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.LAPIS)) {
                this.func_76793_b(worldIn, rand, this.field_180293_d.field_177820_ax, this.field_76831_p, this.field_180293_d.field_177807_ay, this.field_180293_d.field_177805_az);
            }
        }
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Post(worldIn, rand, this.field_180294_c));
    }

    @ParametersAreNonnullByDefault
    protected void generateCustomOres(World worldIn, Random rand) {
        if (this.chocolateBlockGen != null && TerrainGen.generateOre((World)worldIn, (Random)rand, (WorldGenerator)this.chocolateBlockGen, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM)) {
            this.func_76793_b(worldIn, rand, 4, this.chocolateBlockGen, 10, 30);
        }
        if (worldIn.field_73011_w instanceof WorldProviderCandyWorld) {
            if (TerrainGen.generateOre((World)worldIn, (Random)rand, (WorldGenerator)this.sugarSandGen, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM)) {
                this.func_76795_a(worldIn, rand, 20, this.sugarSandGen, 0, 256);
            }
            if (this.soilMilkGen != null && TerrainGen.generateOre((World)worldIn, (Random)rand, (WorldGenerator)this.soilMilkGen, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM)) {
                this.func_76795_a(worldIn, rand, 16, this.soilMilkGen, 0, 256);
            }
            if (this.soilWhiteGen != null && TerrainGen.generateOre((World)worldIn, (Random)rand, (WorldGenerator)this.soilWhiteGen, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM)) {
                this.func_76795_a(worldIn, rand, 16, this.soilWhiteGen, 0, 256);
            }
            if (this.soilDarkGen != null && TerrainGen.generateOre((World)worldIn, (Random)rand, (WorldGenerator)this.soilDarkGen, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM)) {
                this.func_76795_a(worldIn, rand, 16, this.soilDarkGen, 0, 256);
            }
            if (TerrainGen.generateOre((World)worldIn, (Random)rand, (WorldGenerator)this.cookieGen, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM)) {
                this.func_76793_b(worldIn, rand, 80, this.cookieGen, 32, 45);
            }
            if (TerrainGen.generateOre((World)worldIn, (Random)rand, (WorldGenerator)this.teleporterGen, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM)) {
                this.teleporterGen.func_180709_b(worldIn, rand, this.field_180294_c);
            }
        } else {
            if (TerrainGen.generateOre((World)worldIn, (Random)rand, (WorldGenerator)this.cookieGen, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM)) {
                this.func_76793_b(worldIn, rand, 50, this.cookieGen, 32, 45);
            }
            if (TerrainGen.generateOre((World)worldIn, (Random)rand, (WorldGenerator)this.sugarSandGen, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM)) {
                this.func_76795_a(worldIn, rand, 5, this.sugarSandGen, 0, 256);
            }
            if (TerrainGen.generateOre((World)worldIn, (Random)rand, (WorldGenerator)this.sugarBlockGen, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM)) {
                this.func_76795_a(worldIn, rand, 2, this.sugarBlockGen, 0, 30);
            }
            if (this.soilMilkGen != null && TerrainGen.generateOre((World)worldIn, (Random)rand, (WorldGenerator)this.soilMilkGen, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM)) {
                this.func_76795_a(worldIn, rand, 1, this.soilMilkGen, 20, 40);
            }
            if (this.soilWhiteGen != null && TerrainGen.generateOre((World)worldIn, (Random)rand, (WorldGenerator)this.soilWhiteGen, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM)) {
                this.func_76795_a(worldIn, rand, 1, this.soilWhiteGen, 40, 64);
            }
            if (this.soilDarkGen != null && TerrainGen.generateOre((World)worldIn, (Random)rand, (WorldGenerator)this.soilDarkGen, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM)) {
                this.func_76795_a(worldIn, rand, 1, this.soilDarkGen, 0, 25);
            }
        }
    }

    private static class TeleporterOreGenerator
    extends WorldGenerator {
        private TeleporterOreGenerator() {
        }

        @ParametersAreNonnullByDefault
        public boolean func_180709_b(World worldIn, Random rand, BlockPos pos) {
            int count = 6 + rand.nextInt(10);
            for (int i = 0; i < count; ++i) {
                BlockPos blockpos = pos.func_177982_a(rand.nextInt(16) + 8, rand.nextInt(38) + 4, rand.nextInt(16) + 8);
                IBlockState state = worldIn.func_180495_p(blockpos);
                if (!state.func_177230_c().isReplaceableOreGen(state, (IBlockAccess)worldIn, blockpos, (Predicate)BlockMatcher.func_177642_a((Block)ModBlocks.SUGAR_BLOCK))) continue;
                worldIn.func_180501_a(blockpos, ModBlocks.TELEPORTER_ORE.func_176223_P(), 18);
            }
            return true;
        }
    }
}

