/*
 * Decompiled with CFR 0.152.
 */
package com.ochotonida.candymod.world.biome;

import com.ochotonida.candymod.ModBlocks;
import com.ochotonida.candymod.ModConfig;
import com.ochotonida.candymod.block.ModBlockProperties;
import com.ochotonida.candymod.entity.EntityGummyBear;
import com.ochotonida.candymod.entity.EntityGummyMouse;
import com.ochotonida.candymod.enums.EnumGummy;
import com.ochotonida.candymod.world.biome.DecoratorBase;
import com.ochotonida.candymod.world.biome.ModBiome;
import com.ochotonida.candymod.world.dimension.WorldProviderCandyWorld;
import com.ochotonida.candymod.world.worldgen.WorldGenGummyWorm;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenerator;

public class BiomeGummy
extends ModBiome {
    public BiomeGummy() {
        super(new Biome.BiomeProperties("GummySwamp").func_185398_c(0.125f).func_185400_d(0.01f).func_185395_b(0.8f).func_185410_a(0.9f));
        this.setRegistryName("biome_gummy_swamp");
        this.field_76760_I.field_76803_B = -999;
        this.field_76760_I.field_76832_z = -999;
        this.field_76760_I.field_76808_K = true;
        this.field_76752_A = ModBlocks.GUMMY_BLOCK.func_176223_P();
        this.field_76753_B = ModBlocks.HARDENED_GUMMY_BLOCK.func_176223_P();
    }

    @Override
    public void initSpawnList() {
        this.field_76762_K.clear();
        if (ModConfig.weightGummyMouse > 0) {
            int multiplier = ModConfig.preventModdedMobSpawn ? 1000 : 1;
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityGummyMouse.class, ModConfig.weightGummyMouse * multiplier, 4, 10));
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityGummyBear.class, ModConfig.weightGummyBear * multiplier, 2, 5));
        }
    }

    @Override
    @ParametersAreNonnullByDefault
    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        this.generateCustomTerrain(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    public int func_76731_a(float t) {
        return 10746879;
    }

    @Override
    @Nonnull
    public BiomeDecorator func_76729_a() {
        return new Decorator();
    }

    @ParametersAreNonnullByDefault
    public void generateCustomTerrain(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        int seaLevel = worldIn.func_181545_F();
        int j = -1;
        int fillerToPlace = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        EnumGummy gummy_color = EnumGummy.getGummyForGeneration(noiseVal);
        IBlockState topState = this.field_76752_A.func_177226_a(ModBlockProperties.GUMMY_TYPE, (Comparable)((Object)gummy_color));
        IBlockState fillerState = this.field_76753_B.func_177226_a(ModBlockProperties.GUMMY_TYPE, (Comparable)((Object)gummy_color));
        int chunkZ = x & 0xF;
        int chunkX = z & 0xF;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int currentY = 255; currentY >= 0; --currentY) {
            if (currentY <= rand.nextInt(5)) {
                chunkPrimerIn.func_177855_a(chunkX, currentY, chunkZ, field_185367_c);
                continue;
            }
            IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(chunkX, currentY, chunkZ);
            if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                j = -1;
                continue;
            }
            if (iblockstate2.func_177230_c() != Blocks.field_150348_b && iblockstate2.func_177230_c() != ModBlocks.SUGAR_BLOCK) continue;
            if (j == -1) {
                if (currentY >= seaLevel - 4 && currentY <= seaLevel + 1) {
                    topState = this.field_76752_A.func_177226_a(ModBlockProperties.GUMMY_TYPE, (Comparable)((Object)gummy_color));
                    fillerState = this.field_76753_B.func_177226_a(ModBlockProperties.GUMMY_TYPE, (Comparable)((Object)gummy_color));
                }
                if (currentY < seaLevel && (topState == null || topState.func_185904_a() == Material.field_151579_a)) {
                    topState = this.func_180626_a((BlockPos)blockpos$mutableblockpos.func_181079_c(x, currentY, z)) < 0.15f ? field_185371_g : (worldIn.field_73011_w instanceof WorldProviderCandyWorld ? ModBlocks.LIQUID_CHOCOLATE_BLOCK.func_176223_P() : field_185372_h);
                }
                j = fillerToPlace + rand.nextInt(8) + 4;
                if (currentY >= seaLevel - 1) {
                    chunkPrimerIn.func_177855_a(chunkX, currentY, chunkZ, topState);
                    continue;
                }
                if (currentY < seaLevel - 7 - fillerToPlace) {
                    chunkPrimerIn.func_177855_a(chunkX, currentY, chunkZ, field_185368_d);
                    continue;
                }
                chunkPrimerIn.func_177855_a(chunkX, currentY, chunkZ, fillerState);
                continue;
            }
            if (j <= 0) continue;
            --j;
            chunkPrimerIn.func_177855_a(chunkX, currentY, chunkZ, fillerState);
        }
    }

    private class Decorator
    extends DecoratorBase {
        public WorldGenerator gummyWormgen = new WorldGenGummyWorm();

        private Decorator() {
        }

        @Override
        @ParametersAreNonnullByDefault
        protected void genBiomeDecorations(World worldIn, Random rand) {
            for (int i = 0; i < 2; ++i) {
                int x = rand.nextInt(16) + 8;
                int z = rand.nextInt(16) + 8;
                this.gummyWormgen.func_180709_b(worldIn, rand, this.field_180294_c.func_177982_a(x, 0, z));
            }
        }
    }
}

