/*
 * Decompiled with CFR 0.152.
 */
package com.ochotonida.candymod.world.biome;

import com.ochotonida.candymod.ModBlocks;
import com.ochotonida.candymod.ModConfig;
import com.ochotonida.candymod.block.ModBlockProperties;
import com.ochotonida.candymod.entity.EntityCandySheep;
import com.ochotonida.candymod.enums.EnumChocolate;
import com.ochotonida.candymod.world.biome.DecoratorBase;
import com.ochotonida.candymod.world.biome.ModBiome;
import com.ochotonida.candymod.world.worldgen.WorldGenBiomeSpikes;
import com.ochotonida.candymod.world.worldgen.WorldGenCaveCandyCane;
import com.ochotonida.candymod.world.worldgen.WorldGenCottonCandyGrass;
import com.ochotonida.candymod.world.worldgen.WorldGenCottonCandyTree;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;

public class BiomeCottonCandy
extends ModBiome {
    public BiomeCottonCandy() {
        super(new Biome.BiomeProperties("CottonCandyPlains").func_185398_c(0.125f).func_185400_d(0.2f).func_185410_a(0.8f).func_185395_b(0.3f));
        this.setRegistryName("biome_cotton_candy");
        this.field_76760_I.field_76803_B = 20;
        this.field_76760_I.field_76832_z = 1;
        this.field_76760_I.field_76808_K = true;
        this.field_76752_A = ModBlocks.CANDY_GRASS.func_176223_P().func_177226_a(ModBlockProperties.CHOCOLATE_TYPE, (Comparable)((Object)EnumChocolate.MILK));
        this.field_76753_B = ModBlocks.CANDY_SOIL.func_176223_P().func_177226_a(ModBlockProperties.CHOCOLATE_TYPE, (Comparable)((Object)EnumChocolate.MILK));
    }

    @Override
    @Nonnull
    public BiomeDecorator func_76729_a() {
        return new Decorator();
    }

    @Override
    public void initSpawnList() {
        this.field_76762_K.clear();
        if (ModConfig.weightCottonCandySheep > 0) {
            int multiplier = ModConfig.preventModdedMobSpawn ? 1000 : 1;
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityCandySheep.class, ModConfig.weightCottonCandySheep * multiplier, 3, 6));
        }
    }

    public int func_76731_a(float temp) {
        return 0xFFAAEE;
    }

    @Nonnull
    public WorldGenerator func_76730_b(Random rand) {
        return new WorldGenCottonCandyGrass();
    }

    @Nonnull
    public WorldGenAbstractTree func_150567_a(Random rand) {
        return new WorldGenCottonCandyTree(false);
    }

    private class Decorator
    extends DecoratorBase {
        protected int caveCandyCaneAmount = 3;
        protected WorldGenerator candyCaneGen;

        private Decorator() {
        }

        @Override
        protected void initOverworldWorldGens() {
            super.initOverworldWorldGens();
            this.spikesGen = new WorldGenBiomeSpikes(BiomeCottonCandy.this, 3, 8, 8, ModBlocks.SUGAR_BLOCK.func_176223_P());
            this.chocolateBlockGen = new WorldGenMinable(ModBlocks.CHOCOLATE_BLOCK.func_176203_a(EnumChocolate.MILK.getMetadata()), 20);
            this.candyCaneGen = new WorldGenCaveCandyCane();
        }

        @Override
        protected void initDimensionWorldGens() {
            super.initDimensionWorldGens();
            this.spikesGen = new WorldGenBiomeSpikes(BiomeCottonCandy.this, 5, 12, 24, ModBlocks.CHOCOLATE_BLOCK.func_176203_a(EnumChocolate.MILK.getMetadata()));
            this.chocolateBlockGen = new WorldGenMinable(ModBlocks.CHOCOLATE_BLOCK.func_176203_a(EnumChocolate.MILK.getMetadata()), 20);
            this.candyCaneGen = new WorldGenCaveCandyCane();
        }

        @Override
        @ParametersAreNonnullByDefault
        protected void genBiomeDecorations(World worldIn, Random rand) {
            super.genBiomeDecorations(worldIn, rand);
            for (int i = 0; i < this.caveCandyCaneAmount; ++i) {
                int j = rand.nextInt(16) + 8;
                int k = rand.nextInt(16) + 8;
                this.candyCaneGen.func_180709_b(worldIn, rand, this.field_180294_c.func_177982_a(j, 0, k));
            }
        }
    }
}

