/*
 * Decompiled with CFR 0.152.
 */
package com.ochotonida.candymod.world.biome;

import com.ochotonida.candymod.ModBlocks;
import com.ochotonida.candymod.ModConfig;
import com.ochotonida.candymod.block.ModBlockProperties;
import com.ochotonida.candymod.entity.EntityEasterChicken;
import com.ochotonida.candymod.enums.EnumChocolate;
import com.ochotonida.candymod.world.biome.DecoratorBase;
import com.ochotonida.candymod.world.biome.ModBiome;
import com.ochotonida.candymod.world.worldgen.WorldGenBiomeSpikes;
import com.ochotonida.candymod.world.worldgen.WorldGenCaveChocolate;
import com.ochotonida.candymod.world.worldgen.WorldGenChocolateForestGrass;
import com.ochotonida.candymod.world.worldgen.WorldGenChocolateForestTree;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BiomeChocolate
extends ModBiome {
    public BiomeChocolate() {
        super(new Biome.BiomeProperties("ChocolateForest").func_185398_c(-0.12f).func_185400_d(0.05f).func_185410_a(0.8f).func_185395_b(0.3f));
        this.setRegistryName("biome_chocolate_forest");
        this.field_76760_I.field_76803_B = 20;
        this.field_76760_I.field_76832_z = 5;
        this.field_76760_I.field_76808_K = true;
        this.field_76752_A = ModBlocks.CANDY_GRASS.func_176223_P().func_177226_a(ModBlockProperties.CHOCOLATE_TYPE, (Comparable)((Object)EnumChocolate.WHITE));
        this.field_76753_B = ModBlocks.CANDY_SOIL.func_176223_P().func_177226_a(ModBlockProperties.CHOCOLATE_TYPE, (Comparable)((Object)EnumChocolate.WHITE));
    }

    @Override
    @Nonnull
    public BiomeDecorator func_76729_a() {
        return new Decorator();
    }

    @Override
    public void initSpawnList() {
        this.field_76762_K.clear();
        if (ModConfig.weightEasterChicken > 0) {
            int multiplier = ModConfig.preventModdedMobSpawn ? 1000 : 1;
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityEasterChicken.class, ModConfig.weightEasterChicken * multiplier, 3, 7));
        }
    }

    public int func_76731_a(float temp) {
        return 0xFFDDAA;
    }

    @Nonnull
    public WorldGenerator func_76730_b(Random rand) {
        return new WorldGenChocolateForestGrass();
    }

    @Nonnull
    public WorldGenAbstractTree func_150567_a(Random rand) {
        return new WorldGenChocolateForestTree(false);
    }

    private class Decorator
    extends DecoratorBase {
        protected WorldGenerator caveChocolateGen;
        protected int caveChocolateAmount = 5;

        private Decorator() {
        }

        @Override
        protected void initOverworldWorldGens() {
            super.initOverworldWorldGens();
            this.spikesGen = new WorldGenBiomeSpikes(BiomeChocolate.this, 3, 24, 16, ModBlocks.CHOCOLATE_BLOCK.func_176223_P().func_177226_a(ModBlockProperties.CHOCOLATE_TYPE, (Comparable)((Object)EnumChocolate.MILK)), ModBlocks.CHOCOLATE_BLOCK.func_176223_P().func_177226_a(ModBlockProperties.CHOCOLATE_TYPE, (Comparable)((Object)EnumChocolate.WHITE)), ModBlocks.CHOCOLATE_BLOCK.func_176223_P().func_177226_a(ModBlockProperties.CHOCOLATE_TYPE, (Comparable)((Object)EnumChocolate.DARK)));
            this.caveChocolateGen = new WorldGenCaveChocolate();
        }

        @Override
        protected void initDimensionWorldGens() {
            super.initDimensionWorldGens();
            this.spikesGen = new WorldGenBiomeSpikes(BiomeChocolate.this, 3, 24, 16, ModBlocks.CHOCOLATE_BLOCK.func_176223_P().func_177226_a(ModBlockProperties.CHOCOLATE_TYPE, (Comparable)((Object)EnumChocolate.MILK)), ModBlocks.CHOCOLATE_BLOCK.func_176223_P().func_177226_a(ModBlockProperties.CHOCOLATE_TYPE, (Comparable)((Object)EnumChocolate.WHITE)), ModBlocks.CHOCOLATE_BLOCK.func_176223_P().func_177226_a(ModBlockProperties.CHOCOLATE_TYPE, (Comparable)((Object)EnumChocolate.DARK)));
            this.caveChocolateGen = new WorldGenCaveChocolate();
            this.chocolateBlockGen = new WorldGenMinable(ModBlocks.CHOCOLATE_BLOCK.func_176203_a(EnumChocolate.MILK.getMetadata()), 20);
        }

        @Override
        @ParametersAreNonnullByDefault
        protected void genBiomeDecorations(World worldIn, Random rand) {
            super.genBiomeDecorations(worldIn, rand);
            for (int i = 0; i < this.caveChocolateAmount; ++i) {
                int j = rand.nextInt(16) + 8;
                int k = rand.nextInt(16) + 8;
                this.caveChocolateGen.func_180709_b(worldIn, rand, this.field_180294_c.func_177982_a(j, 0, k));
            }
        }

        @Override
        @ParametersAreNonnullByDefault
        protected void generateCustomOres(World worldIn, Random rand) {
            super.generateCustomOres(worldIn, rand);
            if (TerrainGen.generateOre((World)worldIn, (Random)rand, (WorldGenerator)this.cookieGen, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM)) {
                this.func_76793_b(worldIn, rand, 250, this.cookieGen, 32, 2);
            }
        }
    }
}

