/*
 * Decompiled with CFR 0.152.
 */
package com.ochotonida.candymod.proxy;

import com.ochotonida.candymod.ModEntities;
import com.ochotonida.candymod.interfaces.IBlockColored;
import com.ochotonida.candymod.interfaces.IItemColored;
import com.ochotonida.candymod.proxy.CommonProxy;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    private static final List<IBlockColored> coloredBlocks = new ArrayList<IBlockColored>();
    private static final List<IItemColored> coloredItems = new ArrayList<IItemColored>();

    public static void addColoredBlock(IBlockColored block) {
        if (coloredBlocks.contains(block)) {
            throw new IllegalArgumentException();
        }
        coloredBlocks.add(block);
    }

    public static void addColoredItem(IItemColored item) {
        if (coloredItems.contains(item)) {
            throw new IllegalArgumentException();
        }
        coloredItems.add(item);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        ModEntities.initModels();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        this.registerColoring();
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
    }

    @Override
    public void registerItemRenderer(Item item, int meta, String location) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation("candymod:" + location, "inventory"));
    }

    @Override
    public void registerColoring() {
        for (IBlockColored block : coloredBlocks) {
            if (block.getBlockColor() != null) {
                Minecraft.func_71410_x().func_184125_al().func_186722_a(block.getBlockColor(), new Block[]{(Block)block});
            }
            if (block.getBlockColor() == null) continue;
            Minecraft.func_71410_x().getItemColors().func_186731_a(block.getItemColor(), new Block[]{(Block)block});
        }
        for (IItemColored item : coloredItems) {
            if (item.getItemColor() == null) continue;
            Minecraft.func_71410_x().getItemColors().func_186730_a(item.getItemColor(), new Item[]{(Item)item});
        }
    }
}

