/*
 * Decompiled with CFR 0.152.
 */
package com.ochotonida.candymod.item.tools;

import com.ochotonida.candymod.interfaces.IItemToolEdible;
import com.ochotonida.candymod.item.tools.ItemAxeEdible;
import com.ochotonida.candymod.item.tools.ItemPickaxeEdible;
import com.ochotonida.candymod.item.tools.ItemShovelEdible;
import com.ochotonida.candymod.item.tools.ItemSwordEdible;
import net.minecraft.item.Item;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class ToolSet {
    private final ItemPickaxeEdible[] pickaxes;
    private final ItemAxeEdible[] axes;
    private final ItemShovelEdible[] shovels;
    private final ItemSwordEdible[] swords;

    public ToolSet(String name, Item.ToolMaterial toolMaterial, int variants, int healAmount, float saturationModifier) {
        this.pickaxes = new ItemPickaxeEdible[variants];
        this.axes = new ItemAxeEdible[variants];
        this.shovels = new ItemShovelEdible[variants];
        this.swords = new ItemSwordEdible[variants];
        if (variants == 1) {
            this.pickaxes[0] = new ItemPickaxeEdible(name + "_pickaxe", name, toolMaterial, healAmount, saturationModifier);
            this.axes[0] = new ItemAxeEdible(name + "_axe", name, toolMaterial, healAmount, saturationModifier);
            this.shovels[0] = new ItemShovelEdible(name + "_shovel", name, toolMaterial, healAmount, saturationModifier);
            this.swords[0] = new ItemSwordEdible(name + "_sword", name, toolMaterial, healAmount, saturationModifier);
        } else {
            for (int i = 0; i < variants; ++i) {
                this.pickaxes[i] = new ItemPickaxeEdible(name + "_pickaxe_" + this.getVariantSuffix(i), name, toolMaterial, healAmount, saturationModifier);
                this.axes[i] = new ItemAxeEdible(name + "_axe_" + this.getVariantSuffix(i), name, toolMaterial, healAmount, saturationModifier);
                this.shovels[i] = new ItemShovelEdible(name + "_shovel_" + this.getVariantSuffix(i), name, toolMaterial, healAmount, saturationModifier);
                this.swords[i] = new ItemSwordEdible(name + "_sword_" + this.getVariantSuffix(i), name, toolMaterial, healAmount, saturationModifier);
            }
        }
    }

    protected abstract String getVariantSuffix(int var1);

    public final ItemPickaxeEdible getPickaxe(int variant) {
        return this.pickaxes[variant];
    }

    public final ItemAxeEdible getAxe(int variant) {
        return this.axes[variant];
    }

    public final ItemShovelEdible getShovel(int variant) {
        return this.shovels[variant];
    }

    public final ItemSwordEdible getSword(int variant) {
        return this.swords[variant];
    }

    public final void registerItems(IForgeRegistry<Item> registry) {
        registry.registerAll((IForgeRegistryEntry[])this.pickaxes);
        registry.registerAll((IForgeRegistryEntry[])this.axes);
        registry.registerAll((IForgeRegistryEntry[])this.shovels);
        registry.registerAll((IForgeRegistryEntry[])this.swords);
    }

    public final void registerItemModels() {
        for (ItemPickaxeEdible itemPickaxeEdible : this.pickaxes) {
            itemPickaxeEdible.registerItemModel();
        }
        for (IItemToolEdible iItemToolEdible : this.axes) {
            ((ItemAxeEdible)iItemToolEdible).registerItemModel();
        }
        for (IItemToolEdible iItemToolEdible : this.shovels) {
            ((ItemShovelEdible)iItemToolEdible).registerItemModel();
        }
        for (IItemToolEdible iItemToolEdible : this.swords) {
            ((ItemSwordEdible)iItemToolEdible).registerItemModel();
        }
    }
}

