/*
 * Decompiled with CFR 0.152.
 */
package com.ochotonida.candymod.item;

import com.ochotonida.candymod.CandyMod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraftforge.oredict.OreDictionary;

public class ModFoodItem
extends ItemFood {
    private static final List<ModFoodItem> FOOD_ITEMS = new ArrayList<ModFoodItem>();
    protected final String name;
    protected Set<String> oreNames = new HashSet<String>();

    public ModFoodItem(String name, int healAmount, float saturation) {
        super(healAmount, saturation, false);
        this.func_77655_b(name);
        this.setRegistryName(name);
        this.name = name;
        this.func_77637_a(CandyMod.TAB_ITEMS);
        FOOD_ITEMS.add(this);
    }

    public ModFoodItem(String name, int healAmount, float saturation, String ... oreNames) {
        this(name, healAmount, saturation);
        this.oreNames.addAll(Arrays.asList(oreNames));
    }

    public static ModFoodItem[] getFoodItems() {
        return FOOD_ITEMS.toArray(new ModFoodItem[0]);
    }

    protected void registerOreNames() {
        for (String oreName : this.oreNames) {
            OreDictionary.registerOre((String)oreName, (Item)this);
        }
    }

    public static void initOreDict() {
        for (ModFoodItem item : FOOD_ITEMS) {
            item.registerOreNames();
        }
    }

    public void registerItemModel() {
        CandyMod.proxy.registerItemRenderer((Item)this, 0, this.name);
    }

    public static void initItemModels() {
        for (ModFoodItem item : FOOD_ITEMS) {
            item.registerItemModel();
        }
    }
}

