/*
 * Decompiled with CFR 0.152.
 */
package com.ochotonida.candymod.item;

import com.ochotonida.candymod.ModConfig;
import com.ochotonida.candymod.item.ModFoodItem;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTeleporter
extends ModFoodItem {
    public ItemTeleporter() {
        super("teleporter", 1, 1.0f);
        this.func_77848_i();
    }

    @Nonnull
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            entityplayer.func_71024_bL().func_151686_a((ItemFood)this, stack);
            world.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            this.func_77849_c(stack, world, entityplayer);
            entityplayer.func_71029_a(StatList.func_188057_b((Item)this));
            if (entityplayer instanceof EntityPlayerMP && (ModConfig.disableTeleporter || world.field_73011_w.getDimension() == ModConfig.dimensionId)) {
                CriteriaTriggers.field_193138_y.func_193148_a((EntityPlayerMP)entityplayer, stack);
            }
        }
        if (!(entity instanceof EntityPlayer) || world.field_73011_w.getDimension() == ModConfig.dimensionId && !((EntityPlayer)entity).field_71075_bZ.field_75098_d || ModConfig.disableTeleporter) {
            stack.func_190918_g(1);
        }
        if (!world.field_72995_K && entity instanceof EntityPlayer && !ModConfig.disableTeleporter) {
            if (world.field_73011_w.getDimension() == ModConfig.dimensionId) {
                entity.changeDimension(0, (ITeleporter)new CustomTeleporter());
            } else {
                entity.changeDimension(ModConfig.dimensionId, (ITeleporter)new CustomTeleporter());
            }
        }
        return stack;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    private static BlockPos findTargetPos(EntityPlayer player, int targetWorldId) {
        WorldServer targetWorld = player.func_184102_h().func_71218_a(targetWorldId);
        BlockPos targetPos = player.getBedLocation(targetWorldId);
        if (targetPos != null && (targetPos = EntityPlayer.func_180467_a((World)targetWorld, (BlockPos)targetPos, (boolean)false)) == null) {
            player.func_146105_b((ITextComponent)new TextComponentString("Your home bed was missing or obstructed"), false);
            player.setSpawnChunk(null, false, targetWorldId);
        }
        if (targetPos == null) {
            targetPos = targetWorldId == ModConfig.dimensionId ? targetWorld.func_175672_r(new BlockPos((Entity)player)) : targetWorld.func_175672_r(targetWorld.func_175694_M());
        }
        return targetPos;
    }

    public class CustomTeleporter
    implements ITeleporter {
        public void placeEntity(World world, Entity entity, float yaw) {
            if (!(entity instanceof EntityPlayer)) {
                throw new IllegalArgumentException("This teleporter can only teleport players");
            }
            entity.func_174828_a(ItemTeleporter.findTargetPos((EntityPlayer)entity, world.field_73011_w.getDimension()), yaw, entity.field_70125_A);
        }
    }
}

