/*
 * Decompiled with CFR 0.152.
 */
package com.ochotonida.candymod.block.chocolate;

import com.google.common.base.Predicate;
import com.ochotonida.candymod.ModItems;
import com.ochotonida.candymod.block.ModBlockProperties;
import com.ochotonida.candymod.block.chocolate.BlockChocolate;
import com.ochotonida.candymod.enums.EnumChocolate;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockChocolateBar
extends BlockChocolate {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private static final AxisAlignedBB AABB_NS = new AxisAlignedBB(0.15625, 0.0, 0.34375, 0.84375, 0.90625, 0.65625);
    private static final AxisAlignedBB AABB_EW = new AxisAlignedBB(0.34375, 0.0, 0.15625, 0.65625, 0.90625, 0.84375);

    public BlockChocolateBar() {
        super(Material.field_151568_F, "chocolate_bar_block", null);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ModItems.CHOCOLATE_BAR;
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return ((EnumChocolate)((Object)state.func_177229_b(ModBlockProperties.CHOCOLATE_TYPE))).getMetadata();
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public boolean canBlockStay(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.UP);
    }

    @ParametersAreNonnullByDefault
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && this.canBlockStay(worldIn, pos);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (state.func_177229_b((IProperty)FACING) == EnumFacing.NORTH || state.func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
            return AABB_NS;
        }
        return AABB_EW;
    }

    @ParametersAreNonnullByDefault
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (state.func_177229_b((IProperty)FACING) == EnumFacing.NORTH || state.func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
            return AABB_NS;
        }
        return AABB_EW;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    @Nonnull
    public IBlockState func_176203_a(int meta) {
        EnumChocolate type = EnumChocolate.byMetadata(meta % 4);
        int facingbits = (meta & 0xC) >> 2;
        EnumFacing facing = EnumFacing.func_176731_b((int)facingbits);
        return this.func_176223_P().func_177226_a(ModBlockProperties.CHOCOLATE_TYPE, (Comparable)((Object)type)).func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        EnumChocolate type = (EnumChocolate)((Object)state.func_177229_b(ModBlockProperties.CHOCOLATE_TYPE));
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        int typebits = type.getMetadata();
        int facingbits = facing.func_176736_b() << 2;
        return facingbits | typebits;
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ModBlockProperties.CHOCOLATE_TYPE, FACING});
    }

    @Override
    @Nonnull
    public IBlockState func_180642_a(World worldIn, BlockPos psos, EnumFacing blockFaceClickedOn, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumChocolate type = EnumChocolate.byMetadata(meta);
        EnumFacing facing = placer == null ? EnumFacing.NORTH : EnumFacing.func_176733_a((double)placer.field_70177_z);
        return this.func_176223_P().func_177226_a(ModBlockProperties.CHOCOLATE_TYPE, (Comparable)((Object)type)).func_177226_a((IProperty)FACING, (Comparable)facing);
    }
}

