/*
 * Decompiled with CFR 0.152.
 */
package com.ochotonida.candymod;

import com.ochotonida.candymod.CandyMod;
import com.ochotonida.candymod.ModBlocks;
import com.ochotonida.candymod.ModConfig;
import com.ochotonida.candymod.ModItems;
import com.ochotonida.candymod.enums.EnumChocolate;
import com.ochotonida.candymod.item.ModFoodItem;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class ModRecipes {
    private static final ResourceLocation MODRECIPES_GROUP = new ResourceLocation("candymod");

    public static void init() {
        ModRecipes.initOreDict();
        GameRegistry.addSmelting((Item)Items.field_151102_aT, (ItemStack)new ItemStack((Item)ModItems.COTTON_CANDY), (float)0.35f);
        for (EnumChocolate value : EnumChocolate.values()) {
            ItemStack itemStack = new ItemStack((Item)ModItems.CHOCOLATE_BAR, 1, value.getMetadata());
            GameRegistry.addSmelting((ItemStack)new ItemStack((Item)ModItems.CHOCOLATE_EGG, 1, value.getMetadata()), (ItemStack)itemStack, (float)0.4f);
            itemStack = new ItemStack((Item)ModBlocks.CHOCOLATE_BLOCK_IB, 1, value.getMetadata());
            GameRegistry.addSmelting((ItemStack)new ItemStack((Item)ModBlocks.CHOCOLATE_BRICK_IB, 1, value.getMetadata()), (ItemStack)itemStack, (float)0.2f);
        }
    }

    private static void initHarvestcraftRecipes() {
        if (Loader.isModLoaded((String)"harvestcraft") && ModConfig.useHarvestcraftRecipes) {
            CandyMod.LOGGER.info("harvestcraft detected, changing recipe(s)");
        } else {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("candymod", "butter"), (ResourceLocation)MODRECIPES_GROUP, (ItemStack)new ItemStack((Item)ModItems.BUTTER, 1), (Object[])new Object[]{Ingredient.func_193367_a((Item)Items.field_151117_aB)});
        }
    }

    private static void initOreDict() {
        ModFoodItem.initOreDict();
        OreDictionary.registerOre((String)"crystalSugar", (Item)ModItems.SUGAR_ROCK);
        ModBlocks.CHOCOLATE_BLOCK.registerOreNames();
        ModBlocks.CHOCOLATE_BRICK.registerOreNames();
        ModBlocks.CANDY_CANE.registerOreNames();
        ModBlocks.CANDY_SOIL.registerOreNames();
        ModBlocks.GUMMY_BLOCK.registerOreNames();
        ModBlocks.HARDENED_GUMMY_BLOCK.registerOreNames();
        ModBlocks.GUMMY_WORM_BLOCK.registerOreNames();
        OreDictionary.registerOre((String)"blockSugar", (Block)ModBlocks.SUGAR_SAND);
    }
}

