/*
 * Decompiled with CFR 0.152.
 */
package com.ochotonida.candymod;

import java.io.File;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ModConfig {
    public static final String CATEGORY_BIOMES = "biomes";
    public static final String CATEGORY_MOBS = "mobs";
    public static final String CATEGORY_DIMENSION = "dimension";
    public static Configuration config;
    public static int dimensionId;
    public static int weightCottonCandyPlains;
    public static int weightCottonCandyPlainsDim;
    public static int weightChocolateForest;
    public static int weightChocolateForestDim;
    public static int weightGummySwamp;
    public static int weightGummySwampDim;
    public static int weightCottonCandySheep;
    public static int weightEasterChicken;
    public static int weightGummyMouse;
    public static int weightGummyBear;
    public static boolean disableTeleporter;
    public static boolean isGummyTransluscent;
    public static boolean preventModdedMobSpawn;
    public static boolean recursiveTreeTrunks;
    public static boolean stackableTreeTrunks;
    public static boolean useHarvestcraftRecipes;

    public static void loadConfig(File configFile) {
        config = new Configuration(configFile);
        config.load();
        ModConfig.init();
        MinecraftForge.EVENT_BUS.register((Object)new ChangeListener());
    }

    public static void init() {
        String comment = "Dimension id to use for the candy world dimension";
        dimensionId = ModConfig.loadInt(CATEGORY_DIMENSION, "candymod.dimensionId", comment, dimensionId);
        comment = "Setting this to true will prevent players from teleporting to the dimension";
        disableTeleporter = ModConfig.loadBool(CATEGORY_DIMENSION, "candymod.disableTeleporter", comment, disableTeleporter);
        comment = "Overworld cotton candy plains biome weight. 0 to prevent generation in overworld";
        weightCottonCandyPlains = ModConfig.loadInt(CATEGORY_BIOMES, "candymod.weightCottonCandyPlains", comment, weightCottonCandyPlains);
        comment = "Overworld chocolate forest biome weight. 0 to prevent generation in overworld";
        weightChocolateForest = ModConfig.loadInt(CATEGORY_BIOMES, "candymod.weightChocolateForest", comment, weightChocolateForest);
        comment = "Overworld gummy swamp biome weight. 0 to prevent generation in overworld";
        weightGummySwamp = ModConfig.loadInt(CATEGORY_BIOMES, "candymod.weightGummySwamp", comment, weightGummySwamp);
        comment = "Dimension cotton candy plains biome weight";
        weightCottonCandyPlainsDim = ModConfig.loadInt(CATEGORY_BIOMES, "candymod.weightCottonCandyPlainsDim", comment, weightCottonCandyPlainsDim);
        comment = "Dimension chocolate forest biome weight";
        weightChocolateForestDim = ModConfig.loadInt(CATEGORY_BIOMES, "candymod.weightChocolateForestDim", comment, weightChocolateForestDim);
        comment = "Dimension gummy swamp biome weight";
        weightGummySwampDim = ModConfig.loadInt(CATEGORY_BIOMES, "candymod.weightGummySwampDim", comment, weightGummySwampDim);
        comment = "Cotton candy sheep weight. 0 to prevent spawning";
        weightCottonCandySheep = ModConfig.loadInt(CATEGORY_MOBS, "candymod.weightCottonCandySheep", comment, weightCottonCandySheep);
        comment = "Easter chicken weight. 0 to prevent spawning";
        weightEasterChicken = ModConfig.loadInt(CATEGORY_MOBS, "candymod.weightEasterChicken", comment, weightEasterChicken);
        comment = "Gummy mice weight. 0 to prevent spawning";
        weightGummyMouse = ModConfig.loadInt(CATEGORY_MOBS, "candymod.weightGummyMouse", comment, weightGummyMouse);
        comment = "Gummy bear weight. 0 to prevent spawning";
        weightGummyBear = ModConfig.loadInt(CATEGORY_MOBS, "candymod.weightGummyBear", comment, weightGummyBear);
        comment = "setting this to true should prevent any non-Candy World mobs from spawning in candy world biomes";
        preventModdedMobSpawn = ModConfig.loadBool(CATEGORY_MOBS, "candymod.preventModdedMobspawn", comment, preventModdedMobSpawn);
        comment = "Setting this to false will make the game render gummy blocks solid, improving performance";
        isGummyTransluscent = ModConfig.loadBool("client", "candymod.isGummyTransluscent", comment, isGummyTransluscent);
        comment = "With this option enabled, certain recipes will change when harvestcraft is also loaded";
        useHarvestcraftRecipes = ModConfig.loadBool("general", "candymod.useHarvestcraftRecipes", comment, useHarvestcraftRecipes);
        comment = "Setting this to true will make tree trunks take longer to mine the higher they are";
        recursiveTreeTrunks = ModConfig.loadBool("general", "candymod.recursiveTreeTrunks", comment, recursiveTreeTrunks);
        comment = "Setting this to false will make tree trunk blocks behave like normal blocks";
        stackableTreeTrunks = ModConfig.loadBool("general", "candymod.stackableTreeTrunks", comment, stackableTreeTrunks);
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static int loadInt(String category, String name, String comment, int def) {
        Property prop = config.get(category, name, def);
        prop.setComment(comment);
        int val = prop.getInt(def);
        if (val < 0) {
            val = 0;
            prop.set(0);
        }
        return val;
    }

    public static boolean loadBool(String category, String name, String comment, boolean def) {
        Property prop = config.get(category, name, def);
        prop.setComment(comment);
        return prop.getBoolean(def);
    }

    static {
        dimensionId = 23;
        weightCottonCandyPlains = 1;
        weightCottonCandyPlainsDim = 15;
        weightChocolateForest = 1;
        weightChocolateForestDim = 18;
        weightGummySwamp = 1;
        weightGummySwampDim = 11;
        weightCottonCandySheep = 14;
        weightEasterChicken = 14;
        weightGummyMouse = 14;
        weightGummyBear = 11;
        disableTeleporter = false;
        isGummyTransluscent = true;
        preventModdedMobSpawn = false;
        recursiveTreeTrunks = false;
        stackableTreeTrunks = true;
        useHarvestcraftRecipes = true;
    }

    public static class ChangeListener {
        @SubscribeEvent
        public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("candymod")) {
                ModConfig.init();
            }
        }
    }
}

