/*
 * Decompiled with CFR 0.152.
 */
package com.ochotonida.candymod;

import com.ochotonida.candymod.ModBiomes;
import com.ochotonida.candymod.ModBlocks;
import com.ochotonida.candymod.ModConfig;
import com.ochotonida.candymod.ModItems;
import com.ochotonida.candymod.ModRecipes;
import com.ochotonida.candymod.enums.EnumChocolate;
import com.ochotonida.candymod.proxy.CommonProxy;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Logger;

@Mod(modid="candymod", name="Candy World", version="1.1.5", updateJSON="https://github.com/ochotonida/candymod/blob/master/update.json", acceptedMinecraftVersions="[1.12.2]")
public class CandyMod {
    public static final String MODID = "candymod";
    public static final String MODNAME = "Candy World";
    public static final String MODVERSION = "1.1.5";
    public static final ItemTab TAB_ITEMS = new ItemTab();
    public static final BlockTab TAB_BLOCKS = new BlockTab();
    public static final ToolTab TAB_TOOLS = new ToolTab();
    public static Logger LOGGER;
    @Mod.Instance
    public static CandyMod instance;
    @SidedProxy(clientSide="com.ochotonida.candymod.proxy.ClientProxy", serverSide="com.ochotonida.candymod.proxy.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOGGER = event.getModLog();
        ModConfig.loadConfig(event.getSuggestedConfigurationFile());
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) {
        proxy.init(event);
        ModRecipes.init();
        for (ModBiomes.ModBiomeEntry biomeEntry : ModBiomes.biomeEntryList) {
            if (biomeEntry.getWeight() <= 0) continue;
            BiomeManager.addBiome((BiomeManager.BiomeType)biomeEntry.getType(), (BiomeManager.BiomeEntry)biomeEntry.getEntry());
            BiomeManager.addStrongholdBiome((Biome)biomeEntry.getBiome());
        }
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    static {
        FluidRegistry.enableUniversalBucket();
    }

    private static final class ToolTab
    extends CreativeTabs {
        private ToolTab() {
            super("candymod.tools");
        }

        public ItemStack func_78016_d() {
            return new ItemStack((Item)ModItems.TOOLSET_CHOCOLATE.getPickaxe(EnumChocolate.MILK.getMetadata()));
        }
    }

    private static final class ItemTab
    extends CreativeTabs {
        private ItemTab() {
            super("candymod.items");
        }

        public ItemStack func_78016_d() {
            return new ItemStack((Item)ModItems.WAFER_STICK);
        }
    }

    private static final class BlockTab
    extends CreativeTabs {
        private BlockTab() {
            super("candymod.blocks");
        }

        public ItemStack func_78016_d() {
            return new ItemStack((Block)ModBlocks.WAFER_STICK);
        }
    }

    @Mod.EventBusSubscriber
    private static class RegistrationHandler {
        private RegistrationHandler() {
        }

        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            ModBlocks.register((IForgeRegistry<Block>)event.getRegistry());
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            ModItems.register((IForgeRegistry<Item>)event.getRegistry());
            ModBlocks.registerItemBlocks((IForgeRegistry<Item>)event.getRegistry());
        }

        @SubscribeEvent
        public static void registerBiomes(RegistryEvent.Register<Biome> event) {
            ModBiomes.registerBiomes(event);
        }

        @SubscribeEvent
        public static void registerModels(ModelRegistryEvent event) {
            ModItems.registerModels();
            ModBlocks.registerModels();
        }
    }
}

