/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting.gui.widgets;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IFilterLogic;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.utils.SoundUtil;
import forestry.sorting.gui.GuiGeneticFilter;
import forestry.sorting.gui.ISelectableProvider;
import forestry.sorting.gui.widgets.SelectionWidget;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class SpeciesWidget
extends Widget
implements ISelectableProvider<IAlleleSpecies> {
    private static final ImmutableMap<IAlleleSpecies, ItemStack> ITEMS = SpeciesWidget.createEntries();
    private final ImmutableSet<IAlleleSpecies> entries;
    private final EnumFacing facing;
    private final int index;
    private final boolean active;
    private final GuiGeneticFilter gui;

    public SpeciesWidget(WidgetManager manager, int xPos, int yPos, EnumFacing facing, int index, boolean active, GuiGeneticFilter gui) {
        super(manager, xPos, yPos);
        this.facing = facing;
        this.index = index;
        this.active = active;
        this.gui = gui;
        ImmutableSet.Builder entries = ImmutableSet.builder();
        for (ISpeciesRoot root : AlleleManager.alleleRegistry.getSpeciesRoot().values()) {
            IBreedingTracker tracker = root.getBreedingTracker((World)manager.minecraft.field_71441_e, manager.minecraft.field_71439_g.func_146103_bH());
            for (String uid : tracker.getDiscoveredSpecies()) {
                IAllele allele = AlleleManager.alleleRegistry.getAllele(uid);
                if (!(allele instanceof IAlleleSpecies)) continue;
                IAlleleSpecies species = (IAlleleSpecies)allele;
                entries.add((Object)species);
            }
        }
        this.entries = entries.build();
    }

    @Override
    public void draw(int startX, int startY) {
        int x = this.xPos + startX;
        int y = this.yPos + startY;
        IFilterLogic logic = this.gui.getLogic();
        IAlleleSpecies allele = (IAlleleSpecies)logic.getGenomeFilter(this.facing, this.index, this.active);
        if (allele != null) {
            GuiUtil.drawItemStack(this.manager.gui, (ItemStack)ITEMS.getOrDefault((Object)allele, (Object)ItemStack.field_190927_a), x, y);
        }
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        if (this.gui.selection.isSame(this)) {
            textureManager.func_110577_a(SelectionWidget.TEXTURE);
            this.gui.func_73729_b(x - 1, y - 1, 212, 0, 18, 18);
        }
    }

    @Override
    public ImmutableSet<IAlleleSpecies> getEntries() {
        return this.entries;
    }

    @Override
    public void onSelect(@Nullable IAlleleSpecies selectable) {
        IFilterLogic logic = this.gui.getLogic();
        if (logic.setGenomeFilter(this.facing, this.index, this.active, selectable)) {
            logic.sendToServer(this.facing, (short)this.index, this.active, selectable);
        }
        if (this.gui.selection.isSame(this)) {
            this.gui.onModuleClick(this);
        }
        SoundUtil.playButtonClick();
    }

    @Override
    public void draw(GuiForestry gui, IAlleleSpecies selectable, int x, int y) {
        GuiUtil.drawItemStack(gui, (ItemStack)ITEMS.getOrDefault((Object)selectable, (Object)ItemStack.field_190927_a), x, y);
    }

    @Override
    public String getName(IAlleleSpecies selectable) {
        return selectable.getAlleleName();
    }

    @Override
    @Nullable
    public ToolTip getToolTip(int mouseX, int mouseY) {
        IFilterLogic logic = this.gui.getLogic();
        IAlleleSpecies allele = (IAlleleSpecies)logic.getGenomeFilter(this.facing, this.index, this.active);
        if (allele == null) {
            return null;
        }
        ToolTip tooltip = new ToolTip();
        tooltip.add(this.getName(allele));
        return tooltip;
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        IIndividual individual;
        ItemStack stack = this.gui.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        if (!stack.func_190926_b() && (individual = AlleleManager.alleleRegistry.getIndividual(stack)) != null) {
            IGenome genome = individual.getGenome();
            this.onSelect(mouseButton == 0 ? genome.getPrimary() : genome.getSecondary());
            return;
        }
        if (mouseButton == 1) {
            this.onSelect(null);
        } else {
            SoundUtil.playButtonClick();
            this.gui.onModuleClick(this);
        }
    }

    private static ImmutableMap<IAlleleSpecies, ItemStack> createEntries() {
        ImmutableMap.Builder entries = ImmutableMap.builder();
        for (ISpeciesRoot root : AlleleManager.alleleRegistry.getSpeciesRoot().values()) {
            for (IIndividual iIndividual : root.getIndividualTemplates()) {
                IAlleleSpecies species = iIndividual.getGenome().getPrimary();
                ItemStack itemStack = root.getMemberStack(root.templateAsIndividual(root.getTemplate(species)), root.getIconType());
                entries.put((Object)species, (Object)itemStack);
            }
        }
        return entries.build();
    }
}

