/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.compat;

import forestry.core.ModuleCore;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.farming.ModuleFarming;
import forestry.farming.blocks.BlockRegistryFarming;
import forestry.farming.compat.FarmingInfoRecipeCategory;
import forestry.farming.compat.FarmingInfoRecipeMaker;
import forestry.farming.models.EnumFarmBlockTexture;
import forestry.modules.ModuleHelper;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;

@JEIPlugin
public class FarmingJeiPlugin
implements IModPlugin {
    public void register(IModRegistry registry) {
        if (!ModuleHelper.isEnabled("farming")) {
            return;
        }
        registry.addRecipes(FarmingInfoRecipeMaker.getRecipes(), "forestry.farming");
        registry.addRecipeCatalyst((Object)ModuleCore.getItems().circuitboards.get(EnumCircuitBoardType.INTRICATE), new String[]{"forestry.farming"});
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        if (!ModuleHelper.isEnabled("farming")) {
            return;
        }
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new FarmingInfoRecipeCategory(guiHelper)});
    }

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        if (!ModuleHelper.isEnabled("farming")) {
            return;
        }
        BlockRegistryFarming blocks = ModuleFarming.getBlocks();
        Item farmBlock = Item.func_150898_a((Block)blocks.farm);
        subtypeRegistry.registerSubtypeInterpreter(farmBlock, itemStack -> {
            NBTTagCompound nbt = itemStack.func_77978_p();
            EnumFarmBlockTexture texture = EnumFarmBlockTexture.getFromCompound(nbt);
            return itemStack.func_77952_i() + "." + texture.getUid();
        });
    }
}

