/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.core.IErrorLogic;
import forestry.api.recipes.ICarpenterRecipe;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FilteredTank;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.inventory.InventoryGhostCrafting;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.network.PacketBufferForestry;
import forestry.core.recipes.RecipePair;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.IItemStackDisplay;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.core.utils.InventoryUtil;
import forestry.factory.gui.ContainerCarpenter;
import forestry.factory.gui.GuiCarpenter;
import forestry.factory.inventory.InventoryCarpenter;
import forestry.factory.recipes.CarpenterRecipeManager;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileCarpenter
extends TilePowered
implements ISidedInventory,
ILiquidTankTile,
IItemStackDisplay {
    private static final int TICKS_PER_RECIPE_TIME = 1;
    private static final int ENERGY_PER_WORK_CYCLE = 2040;
    private static final int ENERGY_PER_RECIPE_TIME = 204;
    private final FilteredTank resourceTank;
    private final TankManager tankManager;
    private final InventoryAdapterTile craftingInventory;
    private final InventoryCraftResult craftPreviewInventory;
    @Nullable
    private ICarpenterRecipe currentRecipe;
    private NonNullList<String> oreDicts;

    private ItemStack getBoxStack() {
        return this.getInternalInventory().func_70301_a(9);
    }

    public TileCarpenter() {
        super(1100, 4000);
        this.setEnergyPerWorkCycle(2040);
        this.resourceTank = new FilteredTank(10000).setFilters(CarpenterRecipeManager.getRecipeFluids());
        this.craftingInventory = new InventoryGhostCrafting<TileCarpenter>(this, 10);
        this.craftPreviewInventory = new InventoryCraftResult();
        this.setInternalInventory(new InventoryCarpenter(this));
        this.tankManager = new TankManager(this, this.resourceTank);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        this.tankManager.writeToNBT(nbttagcompound);
        this.craftingInventory.writeToNBT(nbttagcompound);
        return nbttagcompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.tankManager.readFromNBT(nbttagcompound);
        this.craftingInventory.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readData(PacketBufferForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readData(data);
    }

    public void checkRecipe() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (CarpenterRecipeManager.matches(this.currentRecipe, this.resourceTank.getFluid(), this.getBoxStack(), (IInventory)this.craftingInventory) == null) {
            RecipePair<ICarpenterRecipe> recipePair = CarpenterRecipeManager.findMatchingRecipe(this.resourceTank.getFluid(), this.getBoxStack(), (IInventory)this.craftingInventory);
            this.currentRecipe = recipePair.getRecipe();
            this.oreDicts = recipePair.getOreDictEntries();
            if (!recipePair.isEmpty()) {
                int recipeTime = this.currentRecipe.getPackagingTime();
                this.setTicksPerWorkCycle(recipeTime * 1);
                this.setEnergyPerWorkCycle(recipeTime * 204);
                ItemStack craftingResult = this.currentRecipe.getCraftingGridRecipe().getOutput();
                this.craftPreviewInventory.func_70299_a(0, craftingResult);
            } else {
                this.craftPreviewInventory.func_70299_a(0, ItemStack.field_190927_a);
            }
        }
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (this.updateOnInterval(20)) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)this, 11);
        }
    }

    @Override
    public boolean workCycle() {
        if (!this.removeLiquidResources(true)) {
            return false;
        }
        if (!this.removeItemResources(true)) {
            return false;
        }
        if (this.currentRecipe != null) {
            ItemStack pendingProduct = this.currentRecipe.getCraftingGridRecipe().getOutput();
            InventoryUtil.tryAddStack((IInventory)this, pendingProduct, 10, 1, true);
        }
        return true;
    }

    private boolean removeLiquidResources(boolean doRemove) {
        if (this.currentRecipe == null) {
            return true;
        }
        FluidStack fluid = this.currentRecipe.getFluidResource();
        if (fluid != null) {
            FluidStack drained = this.resourceTank.drainInternal(fluid, false);
            if (!fluid.isFluidStackIdentical(drained)) {
                return false;
            }
            if (doRemove) {
                this.resourceTank.drainInternal(fluid, true);
            }
        }
        return true;
    }

    private boolean removeItemResources(boolean doRemove) {
        if (this.currentRecipe == null) {
            return true;
        }
        if (!this.currentRecipe.getBox().func_190926_b()) {
            ItemStack box = this.func_70301_a(9);
            if (box.func_190926_b()) {
                return false;
            }
            if (doRemove) {
                this.func_70298_a(9, 1);
            }
        }
        NonNullList<ItemStack> craftingSets = InventoryUtil.getStacks((IInventory)this.craftingInventory, 0, 9);
        InventoryMapper inventory = new InventoryMapper((IInventory)this.getInternalInventory(), 12, 18);
        return InventoryUtil.removeSets((IInventory)inventory, 1, craftingSets, this.oreDicts, null, true, false, doRemove);
    }

    @Override
    public boolean hasWork() {
        if (this.updateOnInterval(20)) {
            this.checkRecipe();
        }
        boolean hasRecipe = this.currentRecipe != null;
        boolean hasLiquidResources = true;
        boolean hasItemResources = true;
        boolean canAdd = true;
        if (hasRecipe) {
            hasLiquidResources = this.removeLiquidResources(false);
            hasItemResources = this.removeItemResources(false);
            ItemStack pendingProduct = this.currentRecipe.getCraftingGridRecipe().getOutput();
            canAdd = InventoryUtil.tryAddStack((IInventory)this, pendingProduct, 10, 1, true, false);
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(!hasRecipe, EnumErrorCode.NO_RECIPE);
        errorLogic.setCondition(!hasLiquidResources, EnumErrorCode.NO_RESOURCE_LIQUID);
        errorLogic.setCondition(!hasItemResources, EnumErrorCode.NO_RESOURCE_INVENTORY);
        errorLogic.setCondition(!canAdd, EnumErrorCode.NO_SPACE_INVENTORY);
        return hasRecipe && hasItemResources && hasLiquidResources && canAdd;
    }

    @Override
    public TankRenderInfo getResourceTankInfo() {
        return new TankRenderInfo((IFluidTank)this.resourceTank);
    }

    public IInventory getCraftingInventory() {
        return this.craftingInventory;
    }

    public IInventory getCraftPreviewInventory() {
        return this.craftPreviewInventory;
    }

    @Override
    public void handleItemStackForDisplay(ItemStack itemStack) {
        this.craftPreviewInventory.func_70299_a(0, itemStack);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tankManager);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(EntityPlayer player, int data) {
        return new GuiCarpenter(player.field_71071_by, this);
    }

    @Override
    public Container getContainer(EntityPlayer player, int data) {
        return new ContainerCarpenter(player.field_71071_by, this);
    }
}

