/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.squeezer;

import forestry.api.recipes.ISqueezerRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.factory.recipes.ISqueezerContainerRecipe;
import forestry.factory.recipes.SqueezerRecipeManager;
import forestry.factory.recipes.jei.squeezer.SqueezerContainerRecipeWrapper;
import forestry.factory.recipes.jei.squeezer.SqueezerRecipeWrapper;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.VanillaTypes;
import net.minecraft.item.ItemStack;

public class SqueezerRecipeMaker {
    private SqueezerRecipeMaker() {
    }

    public static List<SqueezerRecipeWrapper> getSqueezerRecipes() {
        ArrayList<SqueezerRecipeWrapper> recipes = new ArrayList<SqueezerRecipeWrapper>();
        for (ISqueezerRecipe recipe : RecipeManagers.squeezerManager.recipes()) {
            recipes.add(new SqueezerRecipeWrapper(recipe));
        }
        return recipes;
    }

    public static List<SqueezerContainerRecipeWrapper> getSqueezerContainerRecipes(IIngredientRegistry ingredientRegistry) {
        ArrayList<SqueezerContainerRecipeWrapper> recipes = new ArrayList<SqueezerContainerRecipeWrapper>();
        for (ItemStack stack : ingredientRegistry.getAllIngredients(VanillaTypes.ITEM)) {
            ISqueezerContainerRecipe containerRecipe = SqueezerRecipeManager.findMatchingContainerRecipe(stack);
            if (containerRecipe == null) continue;
            recipes.add(new SqueezerContainerRecipeWrapper(containerRecipe, stack));
        }
        return recipes;
    }
}

