/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import com.google.common.base.Preconditions;
import forestry.api.recipes.ISqueezerRecipe;
import forestry.core.utils.ItemStackUtil;
import forestry.factory.recipes.ISqueezerContainerRecipe;
import forestry.factory.recipes.SqueezerRecipe;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class SqueezerContainerRecipe
implements ISqueezerContainerRecipe {
    private final ItemStack emptyContainer;
    private final int processingTime;
    private final ItemStack remnants;
    private final float remnantsChance;

    public SqueezerContainerRecipe(ItemStack emptyContainer, int processingTime, ItemStack remnants, float remnantsChance) {
        Preconditions.checkNotNull((Object)emptyContainer);
        Preconditions.checkArgument((!emptyContainer.func_190926_b() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)remnants);
        this.emptyContainer = emptyContainer;
        this.processingTime = processingTime;
        this.remnants = remnants;
        this.remnantsChance = remnantsChance;
    }

    @Override
    public ItemStack getEmptyContainer() {
        return this.emptyContainer;
    }

    @Override
    public int getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public ItemStack getRemnants() {
        return this.remnants;
    }

    @Override
    public float getRemnantsChance() {
        return this.remnantsChance;
    }

    @Override
    @Nullable
    public ISqueezerRecipe getSqueezerRecipe(ItemStack filledContainer) {
        if (filledContainer.func_190926_b()) {
            return null;
        }
        FluidStack fluidOutput = FluidUtil.getFluidContained((ItemStack)filledContainer);
        if (fluidOutput == null) {
            return null;
        }
        ItemStack filledContainerCopy = ItemStackUtil.createCopyWithCount(filledContainer, 1);
        NonNullList input = NonNullList.func_191196_a();
        input.add((Object)filledContainerCopy);
        return new SqueezerRecipe(this.processingTime, (NonNullList<ItemStack>)input, fluidOutput, this.remnants, this.remnantsChance);
    }
}

