/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import forestry.api.recipes.IFermenterManager;
import forestry.api.recipes.IFermenterRecipe;
import forestry.core.utils.ItemStackUtil;
import forestry.factory.recipes.FermenterRecipe;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FermenterRecipeManager
implements IFermenterManager {
    private static final Set<IFermenterRecipe> recipes = new TreeSet<IFermenterRecipe>();
    public static final Set<Fluid> recipeFluidInputs = new HashSet<Fluid>();
    public static final Set<Fluid> recipeFluidOutputs = new HashSet<Fluid>();

    @Override
    public void addRecipe(ItemStack resource, int fermentationValue, float modifier, FluidStack output, FluidStack liquid) {
        FermenterRecipe recipe = new FermenterRecipe(resource, fermentationValue, modifier, output.getFluid(), liquid);
        this.addRecipe(recipe);
    }

    @Override
    public void addRecipe(ItemStack resource, int fermentationValue, float modifier, FluidStack output) {
        this.addRecipe(resource, fermentationValue, modifier, output, new FluidStack(FluidRegistry.WATER, 1000));
    }

    @Override
    public void addRecipe(String resourceOreName, int fermentationValue, float modifier, FluidStack output, FluidStack liquid) {
        FermenterRecipe recipe = new FermenterRecipe(resourceOreName, fermentationValue, modifier, output.getFluid(), liquid);
        this.addRecipe(recipe);
    }

    @Override
    public void addRecipe(String resourceOreName, int fermentationValue, float modifier, FluidStack output) {
        this.addRecipe(resourceOreName, fermentationValue, modifier, output, new FluidStack(FluidRegistry.WATER, 1000));
    }

    @Nullable
    public static IFermenterRecipe findMatchingRecipe(ItemStack res, FluidStack liqu) {
        if (res.func_190926_b()) {
            return null;
        }
        for (IFermenterRecipe recipe : recipes) {
            if (!FermenterRecipeManager.matches(recipe, res, liqu)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean matches(IFermenterRecipe recipe, ItemStack res, FluidStack liqu) {
        ItemStack resource = recipe.getResource();
        if (!ItemStackUtil.isCraftingEquivalent(resource, res, recipe.getResourceOreName(), false)) {
            return false;
        }
        FluidStack fluid = recipe.getFluidResource();
        return liqu.isFluidEqual(fluid);
    }

    public static boolean isResource(ItemStack resource) {
        if (resource.func_190926_b()) {
            return false;
        }
        for (IFermenterRecipe recipe : recipes) {
            if (!ItemStackUtil.isCraftingEquivalent(recipe.getResource(), resource, recipe.getResourceOreName(), false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addRecipe(IFermenterRecipe recipe) {
        FluidStack liquid = recipe.getFluidResource();
        recipeFluidInputs.add(liquid.getFluid());
        Fluid output = recipe.getOutput();
        recipeFluidOutputs.add(output);
        return recipes.add(recipe);
    }

    @Override
    public boolean removeRecipe(IFermenterRecipe recipe) {
        FluidStack liquid = recipe.getFluidResource();
        recipeFluidInputs.remove(liquid.getFluid());
        Fluid output = recipe.getOutput();
        recipeFluidOutputs.remove(output);
        return recipes.remove(recipe);
    }

    @Override
    public Set<IFermenterRecipe> recipes() {
        return Collections.unmodifiableSet(recipes);
    }
}

