/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import forestry.api.recipes.ICentrifugeManager;
import forestry.api.recipes.ICentrifugeRecipe;
import forestry.core.utils.ItemStackUtil;
import forestry.factory.recipes.CentrifugeRecipe;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class CentrifugeRecipeManager
implements ICentrifugeManager {
    private static final Set<ICentrifugeRecipe> recipes = new HashSet<ICentrifugeRecipe>();

    @Override
    public void addRecipe(int timePerItem, ItemStack resource, Map<ItemStack, Float> products) {
        CentrifugeRecipe recipe = new CentrifugeRecipe(timePerItem, resource, products);
        this.addRecipe(recipe);
    }

    @Nullable
    public static ICentrifugeRecipe findMatchingRecipe(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return null;
        }
        for (ICentrifugeRecipe recipe : recipes) {
            ItemStack recipeInput = recipe.getInput();
            if (!ItemStackUtil.isCraftingEquivalent(recipeInput, itemStack)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public boolean addRecipe(ICentrifugeRecipe recipe) {
        return recipes.add(recipe);
    }

    @Override
    public boolean removeRecipe(ICentrifugeRecipe recipe) {
        return recipes.remove(recipe);
    }

    @Override
    public Set<ICentrifugeRecipe> recipes() {
        return Collections.unmodifiableSet(recipes);
    }
}

