/*
 * Decompiled with CFR 0.152.
 */
package forestry.database.network.packets;

import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketHandlerServer;
import forestry.core.network.IForestryPacketServer;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdServer;
import forestry.database.gui.ContainerDatabase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class PacketExtractItem
extends ForestryPacket
implements IForestryPacketServer {
    public static final int HALF = 1;
    public static final int SHIFT = 2;
    public static final int CLONE = 4;
    private final int invIndex;
    private final byte flags;

    public PacketExtractItem(int invIndex, byte flags) {
        this.invIndex = invIndex;
        this.flags = flags;
    }

    @Override
    protected void writeData(PacketBufferForestry data) {
        data.writeInt(this.invIndex);
        data.writeByte(this.flags);
    }

    @Override
    public PacketIdServer getPacketId() {
        return PacketIdServer.EXTRACT_ITEM;
    }

    public static class Handler
    implements IForestryPacketHandlerServer {
        @Override
        public void onPacketData(PacketBufferForestry data, EntityPlayerMP player) {
            ItemStack extracted;
            int invIndex = data.readInt();
            byte flags = data.readByte();
            if (!player.field_71071_by.func_70445_o().func_190926_b()) {
                return;
            }
            Container container = player.field_71070_bA;
            if (!(container instanceof ContainerDatabase)) {
                return;
            }
            IItemHandler itemHandler = ((ContainerDatabase)container).getItemHandler();
            if (itemHandler == null) {
                return;
            }
            ItemStack itemStack = itemHandler.extractItem(invIndex, 64, true);
            if (itemStack.func_190926_b()) {
                return;
            }
            int maxItemCount = itemStack.func_77973_b().getItemStackLimit(itemStack.func_77946_l());
            int itemCount = itemStack.func_190916_E();
            if ((flags & 4) == 4) {
                ItemStack extracted2 = itemStack.func_77946_l();
                extracted2.func_190920_e(maxItemCount);
                player.field_71071_by.func_70437_b(extracted2);
                if (container instanceof ContainerDatabase) {
                    ((ContainerDatabase)container).sendContainerToListeners();
                }
                return;
            }
            int count = 64;
            if ((flags & 1) == 1 && itemCount > 1) {
                count = itemCount / 2;
            }
            if (!(extracted = itemHandler.extractItem(invIndex, count = Math.min(count, maxItemCount), true)).func_190926_b()) {
                if ((flags & 2) == 2) {
                    IItemHandler playerInv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                    ItemStack remaining = ItemHandlerHelper.insertItem((IItemHandler)playerInv, (ItemStack)extracted, (boolean)true);
                    if (remaining.func_190926_b()) {
                        extracted = itemHandler.extractItem(invIndex, count, false);
                        ItemHandlerHelper.insertItem((IItemHandler)playerInv, (ItemStack)extracted, (boolean)false);
                    }
                } else {
                    extracted = itemHandler.extractItem(invIndex, count, false);
                    player.field_71071_by.func_70437_b(extracted);
                    player.func_71113_k();
                }
                if (container instanceof ContainerDatabase) {
                    ((ContainerDatabase)container).sendContainerToListeners();
                }
            }
        }
    }
}

