/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import forestry.core.render.ForestryResource;
import forestry.core.tiles.TileMill;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class RenderMill
extends TileEntitySpecialRenderer<TileMill> {
    private final ResourceLocation[] textures;
    private final ModelRenderer pedestal;
    private final ModelRenderer column;
    private final ModelRenderer extension;
    private final ModelRenderer blade1;
    private final ModelRenderer blade2;

    public RenderMill(String baseTexture) {
        MillModelBase model = new MillModelBase();
        this.pedestal = new ModelRenderer((ModelBase)model, 0, 0);
        this.pedestal.func_78789_a(-8.0f, -8.0f, -8.0f, 16, 1, 16);
        this.pedestal.field_78800_c = 8.0f;
        this.pedestal.field_78797_d = 8.0f;
        this.pedestal.field_78798_e = 8.0f;
        this.column = new ModelRenderer((ModelBase)model, 0, 0);
        this.column.func_78789_a(-2.0f, -7.0f, -2.0f, 4, 15, 4);
        this.column.field_78800_c = 8.0f;
        this.column.field_78797_d = 8.0f;
        this.column.field_78798_e = 8.0f;
        this.extension = new ModelRenderer((ModelBase)model, 0, 0);
        this.extension.func_78789_a(1.0f, 8.0f, 7.0f, 14, 2, 2);
        this.extension.field_78800_c = 0.0f;
        this.extension.field_78797_d = 0.0f;
        this.extension.field_78798_e = 0.0f;
        this.blade1 = new ModelRenderer((ModelBase)model, 0, 0);
        this.blade1.func_78789_a(-4.0f, -5.0f, -3.0f, 8, 12, 1);
        this.blade1.field_78800_c = 8.0f;
        this.blade1.field_78797_d = 8.0f;
        this.blade1.field_78798_e = 8.0f;
        this.blade2 = new ModelRenderer((ModelBase)model, 0, 0);
        this.blade2.func_78789_a(-4.0f, -5.0f, 2.0f, 8, 12, 1);
        this.blade2.field_78800_c = 8.0f;
        this.blade2.field_78797_d = 8.0f;
        this.blade2.field_78798_e = 8.0f;
        this.textures = new ResourceLocation[12];
        this.textures[Textures.PEDESTAL.ordinal()] = new ForestryResource(baseTexture + "pedestal.png");
        this.textures[Textures.EXTENSION.ordinal()] = new ForestryResource(baseTexture + "extension.png");
        this.textures[Textures.BLADE_1.ordinal()] = new ForestryResource(baseTexture + "blade1.png");
        this.textures[Textures.BLADE_2.ordinal()] = new ForestryResource(baseTexture + "blade2.png");
        for (int i = 0; i < 8; ++i) {
            this.textures[Textures.CHARGE.ordinal() + i] = new ForestryResource(baseTexture + "column_" + i + ".png");
        }
    }

    public RenderMill(String baseTexture, byte charges) {
        this(baseTexture);
    }

    public void render(TileMill mill, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (mill != null) {
            this.render(mill.progress, mill.charge, EnumFacing.WEST, x, y, z);
        } else {
            int charge = 0;
            this.render(0.0f, charge, EnumFacing.WEST, x, y, z);
        }
    }

    private void render(float progress, int charge, EnumFacing orientation, double x, double y, double z) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        float step = (double)progress > 0.5 ? 3.99f - (progress - 0.5f) * 2.0f * 3.99f : progress * 2.0f * 3.99f;
        float[] angle = new float[]{0.0f, 0.0f, 0.0f};
        float[] translate = new float[]{0.0f, 0.0f, 0.0f};
        float tfactor = step / 16.0f;
        switch (orientation) {
            case EAST: {
                angle[1] = (float)Math.PI;
                angle[2] = -1.5707964f;
                translate[0] = 1.0f;
                break;
            }
            case WEST: {
                angle[2] = 1.5707964f;
                translate[0] = -1.0f;
                break;
            }
            case UP: {
                translate[1] = 1.0f;
                break;
            }
            case DOWN: {
                angle[2] = (float)Math.PI;
                translate[1] = -1.0f;
                break;
            }
            case SOUTH: {
                angle[0] = 1.5707964f;
                angle[2] = 1.5707964f;
                translate[2] = 1.0f;
                break;
            }
            default: {
                angle[0] = -1.5707964f;
                angle[2] = 1.5707964f;
                translate[2] = -1.0f;
            }
        }
        this.pedestal.field_78795_f = angle[0];
        this.pedestal.field_78796_g = angle[2];
        this.pedestal.field_78808_h = angle[1];
        this.column.field_78795_f = angle[0];
        this.column.field_78796_g = angle[2];
        this.column.field_78808_h = angle[1];
        this.blade1.field_78795_f = angle[0];
        this.blade1.field_78796_g = angle[2];
        this.blade1.field_78808_h = angle[1];
        this.blade2.field_78795_f = angle[0];
        this.blade2.field_78796_g = angle[2];
        this.blade2.field_78808_h = angle[1];
        float factor = 0.0625f;
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(this.textures[Textures.PEDESTAL.ordinal()]);
        this.pedestal.func_78785_a(factor);
        textureManager.func_110577_a(this.textures[Textures.CHARGE.ordinal() + charge]);
        this.column.func_78785_a(factor);
        textureManager.func_110577_a(this.textures[Textures.EXTENSION.ordinal()]);
        this.extension.func_78785_a(factor);
        textureManager.func_110577_a(this.textures[Textures.BLADE_1.ordinal()]);
        GlStateManager.func_179109_b((float)(translate[0] * tfactor), (float)(translate[1] * tfactor), (float)(translate[2] * tfactor));
        this.blade1.func_78785_a(factor);
        GlStateManager.func_179109_b((float)(-translate[0] * tfactor), (float)(-translate[1] * tfactor), (float)(-translate[2] * tfactor));
        textureManager.func_110577_a(this.textures[Textures.BLADE_2.ordinal()]);
        GlStateManager.func_179109_b((float)(-translate[0] * tfactor), (float)(translate[1] * tfactor), (float)(-translate[2] * tfactor));
        this.blade2.func_78785_a(factor);
        GlStateManager.func_179121_F();
    }

    private static class MillModelBase
    extends ModelBase {
        private MillModelBase() {
        }
    }

    private static enum Textures {
        PEDESTAL,
        EXTENSION,
        BLADE_1,
        BLADE_2,
        CHARGE;

    }
}

