/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import com.google.common.collect.ImmutableMap;
import forestry.api.gui.GuiElementAlignment;
import forestry.api.gui.ITextElement;
import forestry.api.gui.style.ITextStyle;
import forestry.core.gui.elements.GuiElement;
import forestry.core.gui.elements.LabelElement;
import forestry.core.utils.GuiElementUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.GlStateManager;

public class SplitTextElement
extends GuiElement
implements ITextElement {
    private List<String> lines = new ArrayList<String>();
    private String rawText;
    private ITextStyle style;

    public SplitTextElement(int xPos, int yPos, int width, String rawText, GuiElementAlignment align, ITextStyle style) {
        super(xPos, yPos, width, 0);
        this.rawText = rawText;
        this.style = style;
        this.setAlign(align);
        boolean uni = LabelElement.FONT_RENDERER.func_82883_a();
        LabelElement.FONT_RENDERER.func_78264_a(style.isUnicode());
        this.lines.addAll(LabelElement.FONT_RENDERER.func_78271_c(GuiElementUtil.getFormattedString(style, rawText), width));
        LabelElement.FONT_RENDERER.func_78264_a(uni);
        this.setHeight(this.lines.size() * LabelElement.FONT_RENDERER.field_78288_b);
    }

    @Override
    public Collection<String> getLines() {
        return this.lines;
    }

    @Override
    public ITextElement setText(String text) {
        this.rawText = text;
        boolean uni = LabelElement.FONT_RENDERER.func_82883_a();
        LabelElement.FONT_RENDERER.func_78264_a(this.style.isUnicode());
        this.lines.clear();
        this.lines.addAll(LabelElement.FONT_RENDERER.func_78271_c(GuiElementUtil.getFormattedString(this.style, this.rawText), this.width));
        LabelElement.FONT_RENDERER.func_78264_a(uni);
        this.setHeight(this.lines.size() * LabelElement.FONT_RENDERER.field_78288_b);
        return this;
    }

    @Override
    public Map<ITextStyle, String> getRawLines() {
        return ImmutableMap.of((Object)this.style, (Object)this.rawText);
    }

    @Override
    public void drawElement(int mouseX, int mouseY) {
        boolean unicode = LabelElement.FONT_RENDERER.func_82883_a();
        LabelElement.FONT_RENDERER.func_78264_a(this.style.isUnicode());
        int posY = 0;
        for (String text : this.lines) {
            int posX = this.width - LabelElement.FONT_RENDERER.func_78256_a(text);
            posX = (int)((float)posX * this.getAlign().getXOffset());
            LabelElement.FONT_RENDERER.func_78276_b(text, posX, posY, this.style.getColor());
            posY += LabelElement.FONT_RENDERER.field_78288_b;
        }
        LabelElement.FONT_RENDERER.func_78264_a(unicode);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }
}

