/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IClassification;
import forestry.core.utils.Translator;
import java.util.ArrayList;
import java.util.Locale;
import javax.annotation.Nullable;

public class Classification
implements IClassification {
    private final IClassification.EnumClassLevel level;
    private final String uid;
    private final String scientific;
    @Nullable
    private IClassification parent;
    private final ArrayList<IAlleleSpecies> members = new ArrayList();
    private final ArrayList<IClassification> groups = new ArrayList();

    public Classification(IClassification.EnumClassLevel level, String uid, String scientific) {
        this.level = level;
        this.uid = level.name().toLowerCase(Locale.ENGLISH) + "." + uid;
        this.scientific = scientific;
        AlleleManager.alleleRegistry.registerClassification(this);
    }

    @Override
    public IClassification.EnumClassLevel getLevel() {
        return this.level;
    }

    @Override
    public String getUID() {
        return this.uid;
    }

    @Override
    @Nullable
    public IClassification getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IClassification parent) {
        this.parent = parent;
    }

    @Override
    public String getScientific() {
        return this.scientific;
    }

    @Override
    public String getName() {
        return Translator.translateToLocal("for." + this.uid);
    }

    @Override
    public String getDescription() {
        return Translator.translateToLocal("for." + this.uid + ".description");
    }

    @Override
    public IClassification[] getMemberGroups() {
        return this.groups.toArray(new IClassification[this.groups.size()]);
    }

    @Override
    public void addMemberGroup(IClassification group) {
        this.groups.add(group);
        group.setParent(this);
    }

    @Override
    public IAlleleSpecies[] getMemberSpecies() {
        return this.members.toArray(new IAlleleSpecies[this.members.size()]);
    }

    @Override
    public void addMemberSpecies(IAlleleSpecies species) {
        this.members.add(species);
    }
}

