/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.config;

import java.text.NumberFormat;
import java.util.Locale;
import net.minecraftforge.client.MinecraftForgeClient;

public enum EnergyDisplayMode {
    RF("RF", 1.0f),
    FE("FE", 1.0f),
    MJ("MJ", 0.1f),
    TESLA("T", 1.0f);

    private final String energyName;
    private final float factor;

    private EnergyDisplayMode(String energyName, float factor) {
        this.energyName = energyName;
        this.factor = factor;
    }

    public String formatRate(int energy) {
        String amountString = this.formatEnergyNum(energy);
        return String.format("%s %s/t", amountString, this.energyName);
    }

    public String formatEnergyValue(int energy) {
        String amountString = this.formatEnergyNum(energy);
        return String.format("%s %s", amountString, this.energyName);
    }

    private String formatEnergyNum(int energy) {
        Locale locale = MinecraftForgeClient.getLocale();
        NumberFormat numberFormat = NumberFormat.getIntegerInstance(locale);
        float amount = (float)energy * this.factor;
        return numberFormat.format(amount);
    }
}

