/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenHelper;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenPapaya
extends WorldGenTree {
    public WorldGenPapaya(ITreeGenData tree) {
        super(tree, 7, 2);
    }

    @Override
    public Set<BlockPos> generateTrunk(World world, Random rand, TreeBlockTypeLog wood, BlockPos startPos) {
        WorldGenHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, this.girth, 0, 0.0f, null, 0.0f);
        return WorldGenHelper.generateBranches(world, rand, wood, startPos.func_177982_a(0, this.height - 1, 0), this.girth, 0.15f, 0.25f, this.height / 4, 1, 0.25f);
    }

    @Override
    protected void generateLeaves(World world, Random rand, TreeBlockTypeLeaf leaf, List<BlockPos> branchEnds, BlockPos startPos) {
        for (BlockPos branchEnd : branchEnds) {
            WorldGenHelper.generateCylinderFromPos(world, leaf, branchEnd, 1 + this.girth, 1, WorldGenHelper.EnumReplaceMode.AIR);
        }
        int yCenter = this.height - this.girth;
        yCenter = yCenter > 3 ? yCenter : 4;
        WorldGenHelper.generateSphereFromTreeStartPos(world, startPos.func_177982_a(0, yCenter, 0), this.girth, Math.round((float)(2 + rand.nextInt(this.girth)) * ((float)this.height / 8.0f)), leaf, WorldGenHelper.EnumReplaceMode.AIR);
    }
}

