/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.flowers;

import forestry.api.genetics.ICheckPollinatable;
import forestry.api.genetics.IFlowerProvider;
import forestry.api.genetics.IIndividual;
import forestry.core.utils.Translator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public class FlowerProvider
implements IFlowerProvider {
    private final String flowerType;
    private final String unlocalizedDescription;

    public FlowerProvider(String flowerType, String unlocalizedDescription) {
        this.flowerType = flowerType;
        this.unlocalizedDescription = unlocalizedDescription;
    }

    @Override
    public String getFlowerType() {
        return this.flowerType;
    }

    @Override
    public boolean isAcceptedPollinatable(World world, ICheckPollinatable pollinatable) {
        EnumPlantType plantType = pollinatable.getPlantType();
        switch (this.flowerType) {
            case "flowersNether": {
                return plantType == EnumPlantType.Nether;
            }
            case "flowersCacti": {
                return plantType == EnumPlantType.Desert;
            }
        }
        return plantType != EnumPlantType.Nether;
    }

    @Override
    public String getDescription() {
        return Translator.translateToLocal(this.unlocalizedDescription);
    }

    @Override
    public NonNullList<ItemStack> affectProducts(World world, IIndividual individual, BlockPos pos, NonNullList<ItemStack> products) {
        return products;
    }
}

