/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.blocks;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IHiveDrop;
import forestry.api.apiculture.IHiveTile;
import forestry.api.apiculture.hives.IHiveRegistry;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.Tabs;
import forestry.api.genetics.ISpeciesType;
import forestry.apiculture.MaterialBeehive;
import forestry.apiculture.ModuleApiculture;
import forestry.apiculture.tiles.TileHive;
import forestry.core.blocks.IBlockWithMeta;
import forestry.core.tiles.TileUtil;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBeeHives
extends BlockContainer
implements IItemModelRegister,
IBlockWithMeta {
    private static final PropertyEnum<IHiveRegistry.HiveType> HIVE_TYPES = PropertyEnum.func_177709_a((String)"hive", IHiveRegistry.HiveType.class);

    public BlockBeeHives() {
        super((Material)new MaterialBeehive(true));
        this.func_149715_a(0.4f);
        this.func_149711_c(2.5f);
        this.func_149647_a(Tabs.tabApiculture);
        this.setHarvestLevel("scoop", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(HIVE_TYPES, (Comparable)((Object)IHiveRegistry.HiveType.FOREST)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HIVE_TYPES});
    }

    public int func_176201_c(IBlockState state) {
        return ((IHiveRegistry.HiveType)((Object)state.func_177229_b(HIVE_TYPES))).getMeta();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(HIVE_TYPES, (Comparable)((Object)IHiveRegistry.HiveType.VALUES[meta]));
    }

    public IBlockState getStateForType(IHiveRegistry.HiveType type) {
        return this.func_176223_P().func_177226_a(HIVE_TYPES, (Comparable)((Object)type));
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileHive();
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        super.func_180649_a(world, pos, player);
        TileUtil.actOnTile((IBlockAccess)world, pos, IHiveTile.class, tile -> tile.onAttack(world, pos, player));
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        boolean canHarvest = this.canHarvestBlock((IBlockAccess)world, pos, player);
        TileUtil.actOnTile((IBlockAccess)world, pos, IHiveTile.class, tile -> tile.onBroken(world, pos, player, canHarvest));
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        IBee bee;
        Random random = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        List<IHiveDrop> hiveDrops = BlockBeeHives.getDropsForHive(this.func_176201_c(state));
        Collections.shuffle(hiveDrops);
        int tries = 0;
        boolean hasPrincess = false;
        block0: while (tries <= 10 && !hasPrincess) {
            ++tries;
            for (IHiveDrop drop : hiveDrops) {
                if (!(random.nextDouble() < drop.getChance(world, pos, fortune))) continue;
                bee = drop.getBeeType(world, pos);
                if ((double)random.nextFloat() < drop.getIgnobleChance(world, pos, fortune)) {
                    bee.setIsNatural(false);
                }
                ItemStack princess = BeeManager.beeRoot.getMemberStack(bee, (ISpeciesType)EnumBeeType.PRINCESS);
                drops.add((Object)princess);
                hasPrincess = true;
                continue block0;
            }
        }
        for (IHiveDrop drop : hiveDrops) {
            if (!(random.nextDouble() < drop.getChance(world, pos, fortune))) continue;
            bee = drop.getBeeType(world, pos);
            ItemStack drone = BeeManager.beeRoot.getMemberStack(bee, (ISpeciesType)EnumBeeType.DRONE);
            drops.add((Object)drone);
            break;
        }
        for (IHiveDrop drop : hiveDrops) {
            if (!(random.nextDouble() < drop.getChance(world, pos, fortune))) continue;
            drops.addAll(drop.getExtraItems(world, pos, fortune));
            break;
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    private static List<IHiveDrop> getDropsForHive(int meta) {
        String hiveName = BlockBeeHives.getHiveNameForMeta(meta);
        if (hiveName == null || hiveName.equals(IHiveRegistry.HiveType.SWARM.getHiveUid())) {
            return Collections.emptyList();
        }
        return ModuleApiculture.getHiveRegistry().getDrops(hiveName);
    }

    @Nullable
    private static String getHiveNameForMeta(int meta) {
        if (meta < 0 || meta >= IHiveRegistry.HiveType.VALUES.length) {
            return null;
        }
        return IHiveRegistry.HiveType.VALUES[meta].getHiveUid();
    }

    public static IHiveRegistry.HiveType getHiveType(IBlockState state) {
        return (IHiveRegistry.HiveType)((Object)state.func_177229_b(HIVE_TYPES));
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (IBlockState blockState : this.func_176194_O().func_177619_a()) {
            if (BlockBeeHives.getHiveType(blockState) == IHiveRegistry.HiveType.SWARM) continue;
            int meta = this.func_176201_c(blockState);
            list.add((Object)new ItemStack((Block)this, 1, meta));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        for (IHiveRegistry.HiveType hiveType : IHiveRegistry.HiveType.VALUES) {
            manager.registerItemModel(item, hiveType.getMeta(), "beehives/" + hiveType.func_176610_l());
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public String getNameFromMeta(int meta) {
        return IHiveRegistry.HiveType.VALUES[meta].func_176610_l();
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 5;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return true;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 5;
    }
}

