/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.genetics;

import com.mojang.authlib.GameProfile;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IAlyzerPlugin;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IDatabasePlugin;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IIndividualTranslator;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface ISpeciesRoot {
    public String getUID();

    public Class<? extends IIndividual> getMemberClass();

    public int getSpeciesCount();

    public boolean isMember(ItemStack var1);

    public boolean isMember(ItemStack var1, ISpeciesType var2);

    public boolean isMember(IIndividual var1);

    @Nullable
    public IIndividual getMember(ItemStack var1);

    public IIndividual getMember(NBTTagCompound var1);

    public <O, I extends IIndividual> void registerTranslator(Object var1, IIndividualTranslator<I, O> var2);

    @Nullable
    public <O, I extends IIndividual> IIndividualTranslator<I, O> getTranslator(Object var1);

    @Nullable
    public <O, I extends IIndividual> I translateMember(O var1);

    @Nullable
    public ISpeciesType getType(ItemStack var1);

    public ISpeciesType getIconType();

    default public ISpeciesType[] getTypes() {
        return new ISpeciesType[0];
    }

    public ItemStack getMemberStack(IIndividual var1, ISpeciesType var2);

    default public ItemStack getMemberStack(IAlleleSpecies species, ISpeciesType type) {
        return this.getMemberStack(this.getTemplate(species), type);
    }

    default public ItemStack getMemberStack(IAllele[] template, ISpeciesType type) {
        return this.getMemberStack(this.templateAsIndividual(template), type);
    }

    public IBreedingTracker getBreedingTracker(World var1, @Nullable GameProfile var2);

    public IIndividual templateAsIndividual(IAllele[] var1);

    public IIndividual templateAsIndividual(IAllele[] var1, IAllele[] var2);

    public IChromosome[] templateAsChromosomes(IAllele[] var1);

    public IChromosome[] templateAsChromosomes(IAllele[] var1, IAllele[] var2);

    public IGenome templateAsGenome(IAllele[] var1);

    public IGenome templateAsGenome(IAllele[] var1, IAllele[] var2);

    public void registerTemplate(IAllele[] var1);

    public void registerTemplate(String var1, IAllele[] var2);

    @Nullable
    public IAllele[] getTemplate(String var1);

    public IAllele[] getTemplate(IAlleleSpecies var1);

    public IAllele[] getDefaultTemplate();

    public IAllele[] getRandomTemplate(Random var1);

    public Map<String, IAllele[]> getGenomeTemplates();

    public List<? extends IIndividual> getIndividualTemplates();

    default public ISpeciesType getTypeForMutation(int position) {
        return this.getIconType();
    }

    public void registerMutation(IMutation var1);

    public List<? extends IMutation> getMutations(boolean var1);

    public List<? extends IMutation> getCombinations(IAllele var1);

    public List<? extends IMutation> getResultantMutations(IAllele var1);

    public List<IMutation> getCombinations(IAlleleSpecies var1, IAlleleSpecies var2, boolean var3);

    public Collection<? extends IMutation> getPaths(IAllele var1, IChromosomeType var2);

    public Map<ItemStack, Float> getResearchCatalysts();

    public void setResearchSuitability(ItemStack var1, float var2);

    public IChromosomeType[] getKaryotype();

    public IChromosomeType getSpeciesChromosomeType();

    public IAlyzerPlugin getAlyzerPlugin();

    @Nullable
    @SideOnly(value=Side.CLIENT)
    default public IDatabasePlugin getSpeciesPlugin() {
        return null;
    }
}

