/*
 * Decompiled with CFR 0.152.
 */
package tehnut.harvest;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tehnut.harvest.BlockStack;
import tehnut.harvest.HarvestConfig;
import tehnut.harvest.IReplantHandler;
import tehnut.harvest.JsonConfigHandler;

@Mod(modid="harvest", name="Harvest", version="1.12-1.2.8-25", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.11,1.13)")
public class Harvest {
    public static final String MODID = "harvest";
    public static final String NAME = "Harvest";
    public static final String VERSION = "1.12-1.2.8-25";
    public static final Logger LOGGER = LogManager.getLogger((String)"Harvest");
    public static final Map<Block, IReplantHandler> CUSTOM_HANDLERS = new HashMap<Block, IReplantHandler>();
    public static final Method _GET_SEED = ReflectionHelper.findMethod(BlockCrops.class, (String)"getSeed", (String)"func_149866_i", (Class[])new Class[0]);
    public static HarvestConfig config;

    @Mod.EventHandler
    public void init(FMLPostInitializationEvent event) {
        JsonConfigHandler.init(Loader.instance().getConfigDir());
    }

    @Mod.EventBusSubscriber
    public static class EventHandler {
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onInteract(PlayerInteractEvent.RightClickBlock event) {
            if (event.getHand() != EnumHand.MAIN_HAND) {
                return;
            }
            BlockStack worldBlock = BlockStack.getStackFromPos(event.getWorld(), event.getPos());
            if (config.getCropMap().containsKey(worldBlock)) {
                if (CUSTOM_HANDLERS.containsKey(worldBlock.getBlock())) {
                    CUSTOM_HANDLERS.get(worldBlock.getBlock()).handlePlant(event.getWorld(), event.getPos(), worldBlock.getState(), event.getEntityPlayer(), event.getWorld().func_175625_s(event.getPos()));
                } else {
                    EventHandler.defaultHandlePlant(event.getWorld(), event.getPos(), worldBlock.getState(), event.getEntityPlayer(), worldBlock);
                }
                event.getEntityPlayer().func_184609_a(EnumHand.MAIN_HAND);
                event.setUseItem(Event.Result.DENY);
                event.getEntityPlayer().func_71020_j(config.getExhaustionPerHarvest());
            }
        }

        private static void defaultHandlePlant(World world, BlockPos pos, IBlockState state, EntityPlayer player, BlockStack worldBlock) {
            BlockStack newBlock = config.getCropMap().get(worldBlock).getFinalBlock();
            NonNullList drops = NonNullList.func_191196_a();
            worldBlock.getBlock().getDrops(drops, (IBlockAccess)world, pos, state, 0);
            ForgeEventFactory.fireBlockHarvesting((List)drops, (World)world, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)false, (EntityPlayer)player);
            boolean foundSeed = false;
            for (ItemStack stack : drops) {
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IPlantable)) continue;
                stack.func_190918_g(1);
                foundSeed = true;
                break;
            }
            boolean seedNotNull = true;
            if (worldBlock.getBlock() instanceof BlockCrops) {
                try {
                    Item seed = (Item)_GET_SEED.invoke((Object)worldBlock.getBlock(), new Object[0]);
                    seedNotNull = seed != null && seed != Items.field_190931_a;
                }
                catch (Exception e) {
                    LOGGER.error("Failed to reflect BlockCrops: {}", (Object)e.getLocalizedMessage());
                }
            }
            if (seedNotNull && foundSeed) {
                if (!world.field_72995_K) {
                    world.func_175656_a(pos, newBlock.getState());
                    for (ItemStack stack : drops) {
                        EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
                        entityItem.func_174867_a(10);
                        world.func_72838_d((Entity)entityItem);
                    }
                }
            } else if (config.shouldLog()) {
                LOGGER.info("Did not harvest. seedNotNull - {}, foundSeed - {}", (Object)seedNotNull, (Object)foundSeed);
            }
        }
    }
}

