/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.moresoundconfig;

import ichttt.mods.moresoundconfig.MSCConfig;
import ichttt.mods.moresoundconfig.MoreSoundConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCdevice;

public class SoundDevices {
    public static final List<String> validDevices = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadDeviceList() {
        List<String> list = validDevices;
        synchronized (list) {
            boolean success = false;
            try {
                success = !SoundDevices.reloadDeviceList0();
            }
            catch (UnsatisfiedLinkError e) {
                MoreSoundConfig.LOGGER.error("Failed to reload device list! Native lib not hooked!", (Throwable)e);
            }
            catch (RuntimeException e) {
                MoreSoundConfig.LOGGER.error("Failed to reload device list! Unexpected error!", (Throwable)e);
            }
            if (!success) {
                validDevices.clear();
            }
        }
    }

    public static boolean reloadDeviceList0() {
        validDevices.clear();
        boolean errorOccurred = false;
        if (ALC10.alcIsExtensionPresent(null, (String)"ALC_enumerate_all_EXT")) {
            String[] devices;
            MoreSoundConfig.LOGGER.info("Reading sound devices");
            String s = ALC10.alcGetString(null, (int)4115);
            for (String deviceName : devices = s.split("\u0000")) {
                boolean success;
                String error = null;
                ALCdevice device = ALC10.alcOpenDevice((String)deviceName);
                if (device == null) {
                    error = "null device";
                } else if (!device.isValid()) {
                    error = "invalid device";
                }
                int code = ALC10.alcGetError((ALCdevice)device);
                if (code != 0) {
                    error = code + "";
                }
                if (device != null && !(success = ALC10.alcCloseDevice((ALCdevice)device))) {
                    error = "Could not close";
                }
                if (error != null) {
                    errorOccurred = true;
                    MoreSoundConfig.LOGGER.error("Error testing device " + deviceName);
                    MoreSoundConfig.LOGGER.error("Error code: " + error);
                    continue;
                }
                MoreSoundConfig.LOGGER.debug("Found valid device " + deviceName);
                validDevices.add(deviceName);
            }
        } else {
            MoreSoundConfig.LOGGER.warn("Could not list devices - operation not supported by sound driver!");
            return true;
        }
        return errorOccurred;
    }

    public static boolean validateActiveOutput(String output) {
        return output == null || validDevices.contains(output);
    }

    public static void updateOutput(String newValue) {
        if (newValue == null) {
            newValue = "";
        }
        MSCConfig.activeSoundDevice = newValue;
        Minecraft.func_71410_x().func_152344_a(() -> ConfigManager.sync((String)"moresoundconfig", (Config.Type)Config.Type.INSTANCE));
    }
}

