/*
 * Decompiled with CFR 0.152.
 */
package org.dave.bonsaitrees.utility;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.launchwrapper.Launch;
import org.dave.bonsaitrees.BonsaiTrees;
import org.dave.bonsaitrees.utility.Logz;

public class ResourceLoader {
    public static final boolean DEVELOPMENT = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    private final String runtimePathName;
    private final String assetPathName;

    public ResourceLoader(File runtimeFile, String assetPathName) {
        this.assetPathName = assetPathName;
        this.runtimePathName = runtimeFile.getAbsolutePath();
    }

    public ResourceLoader(String runtimePathName, String assetPathName) {
        this.runtimePathName = runtimePathName;
        this.assetPathName = assetPathName;
    }

    public Map<String, InputStream> getResources() {
        HashMap<String, InputStream> result;
        block12: {
            block11: {
                result = new HashMap<String, InputStream>();
                File runtimePath = new File(this.runtimePathName);
                if (runtimePath.exists() && runtimePath.isDirectory()) {
                    for (File file : runtimePath.listFiles()) {
                        try {
                            result.put(file.getName(), new FileInputStream(file));
                            Logz.debug(" - Loading file '%s' from config folder", file.getName());
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            // empty catch block
                        }
                    }
                }
                if (!DEVELOPMENT) break block11;
                File assetPath = new File(BonsaiTrees.class.getResource("/" + this.assetPathName).getFile());
                if (!assetPath.exists() || !assetPath.isDirectory()) break block12;
                for (File file : assetPath.listFiles()) {
                    if (result.keySet().contains(file.getName())) continue;
                    try {
                        result.put(file.getName(), new FileInputStream(file));
                        Logz.debug(" - Loading file '%s' from development assets folder", file.getName());
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
                break block12;
            }
            URL srcUrl = BonsaiTrees.class.getResource("/" + this.assetPathName);
            if (srcUrl == null || !srcUrl.getProtocol().equals("jar")) {
                Logz.error("Error while reading files from jar: unable to get Resource URL for '%s'.", this.assetPathName);
                return null;
            }
            try {
                JarURLConnection jarURLConnection = (JarURLConnection)srcUrl.openConnection();
                JarFile zipFile = jarURLConnection.getJarFile();
                Enumeration<? extends ZipEntry> zipEntries = ((ZipFile)zipFile).entries();
                while (zipEntries.hasMoreElements()) {
                    ZipEntry zipEntry = zipEntries.nextElement();
                    String zipName = zipEntry.getName();
                    if (!zipName.startsWith(this.assetPathName)) continue;
                    String filename = zipName.substring(this.assetPathName.length());
                    if (result.keySet().contains(filename) || filename.length() == 0) continue;
                    result.put(filename, ((ZipFile)zipFile).getInputStream(zipEntry));
                    Logz.debug(" - Loading file '%s' from jar", filename);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

