/*
 * Decompiled with CFR 0.152.
 */
package org.dave.bonsaitrees.soils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import org.dave.bonsaitrees.api.IBonsaiSoil;
import org.dave.bonsaitrees.api.IBonsaiTreeType;
import org.dave.bonsaitrees.api.ISoilCompatibilityHelper;
import org.dave.bonsaitrees.compat.CraftTweaker2.registries.TagModificationsRegistry;
import org.dave.bonsaitrees.soils.BonsaiSoilRegistry;
import org.dave.bonsaitrees.trees.TreeTypeRegistry;
import org.dave.bonsaitrees.utility.Logz;

public class SoilCompatibility
implements ISoilCompatibilityHelper {
    private Map<IBonsaiTreeType, Set<IBonsaiSoil>> soilCompatibility = new HashMap<IBonsaiTreeType, Set<IBonsaiSoil>>();
    private Map<IBonsaiSoil, Set<IBonsaiTreeType>> treeCompatibility = new HashMap<IBonsaiSoil, Set<IBonsaiTreeType>>();

    @Override
    public Set<IBonsaiSoil> getValidSoilsForTree(IBonsaiTreeType tree) {
        return this.soilCompatibility.getOrDefault(tree, new HashSet());
    }

    @Override
    public Set<IBonsaiTreeType> getValidTreesForSoil(IBonsaiSoil soil) {
        return this.treeCompatibility.getOrDefault(soil, new HashSet());
    }

    @Override
    public boolean canTreeGrowOnSoil(IBonsaiTreeType tree, IBonsaiSoil soil) {
        if (!this.soilCompatibility.containsKey(tree) || this.soilCompatibility.get(tree) == null) {
            return false;
        }
        return this.soilCompatibility.get(tree).contains(soil);
    }

    @Override
    public boolean isValidSoil(ItemStack soilStack) {
        for (IBonsaiSoil soil : this.treeCompatibility.keySet()) {
            if (!soil.matchesStack(soilStack)) continue;
            return true;
        }
        return false;
    }

    private void addCompatEntry(IBonsaiSoil soil, IBonsaiTreeType tree) {
        if (!this.soilCompatibility.containsKey(tree)) {
            this.soilCompatibility.put(tree, new HashSet());
        }
        this.soilCompatibility.get(tree).add(soil);
        if (!this.treeCompatibility.containsKey(soil)) {
            this.treeCompatibility.put(soil, new HashSet());
        }
        this.treeCompatibility.get(soil).add(tree);
    }

    public void updateCompatibility(BonsaiSoilRegistry soilRegistry, TreeTypeRegistry typeRegistry) {
        this.soilCompatibility = new HashMap<IBonsaiTreeType, Set<IBonsaiSoil>>();
        this.treeCompatibility = new HashMap<IBonsaiSoil, Set<IBonsaiTreeType>>();
        HashMap reverseSoilTagMap = new HashMap();
        for (IBonsaiSoil soil : soilRegistry.getAllSoils()) {
            for (String tag : TagModificationsRegistry.getModifiedTagList(soil)) {
                if (!reverseSoilTagMap.containsKey(tag)) {
                    reverseSoilTagMap.put(tag, new HashSet());
                }
                ((Set)reverseSoilTagMap.get(tag)).add(soil);
            }
        }
        for (IBonsaiTreeType tree : typeRegistry.getAllTypes()) {
            for (String tag : TagModificationsRegistry.getModifiedTagList(tree)) {
                if (!reverseSoilTagMap.containsKey(tag)) continue;
                for (IBonsaiSoil soil : (Set)reverseSoilTagMap.get(tag)) {
                    Logz.debug("Tree %s grows on %s because of %s", tree.getName(), soil.getName(), tag);
                    this.addCompatEntry(soil, tree);
                }
            }
        }
    }
}

