/*
 * Decompiled with CFR 0.152.
 */
package org.dave.bonsaitrees.soils;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import org.dave.bonsaitrees.api.IBonsaiIntegration;
import org.dave.bonsaitrees.api.IBonsaiSoil;
import org.dave.bonsaitrees.api.IBonsaiSoilRegistry;
import org.dave.bonsaitrees.misc.ConfigurationHandler;
import org.dave.bonsaitrees.utility.Logz;

public class BonsaiSoilRegistry
implements IBonsaiSoilRegistry {
    private Map<String, IBonsaiSoil> soils = new HashMap<String, IBonsaiSoil>();
    private Map<IBonsaiSoil, IBonsaiIntegration> integrationMap = new HashMap<IBonsaiSoil, IBonsaiIntegration>();

    public void clear() {
        this.soils = new HashMap<String, IBonsaiSoil>();
        this.integrationMap = new HashMap<IBonsaiSoil, IBonsaiIntegration>();
    }

    @Override
    public void registerBonsaiSoilIntegration(IBonsaiIntegration integrator, IBonsaiSoil soil) {
        if (Arrays.asList(ConfigurationHandler.IntegrationSettings.disabledSoils).contains(soil.getName())) {
            Logz.info("Soil %s has been disabled via config. Skipping...", soil.getName());
            return;
        }
        if (this.soils.containsKey(soil.getName())) {
            Logz.info("Soil %s has already been loaded before. Skipping...", soil.getName());
            return;
        }
        if (soil.getSoilStack().func_190926_b()) {
            Logz.info("Soil %s has no soil stack. Skipping...", soil.getName());
            return;
        }
        this.soils.put(soil.getName(), soil);
        this.integrationMap.put(soil, integrator);
    }

    public boolean isValidSoil(ItemStack stack) {
        return this.getTypeByStack(stack) != null;
    }

    public Collection<IBonsaiSoil> getAllSoils() {
        return this.soils.values();
    }

    public IBonsaiSoil getTypeByName(String name) {
        return this.soils.get(name);
    }

    public IBonsaiSoil getTypeByStack(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return null;
        }
        for (IBonsaiSoil soil : this.soils.values()) {
            if (!soil.matchesStack(stack)) continue;
            return soil;
        }
        return null;
    }

    public IBonsaiIntegration getIntegrationForSoil(IBonsaiSoil soil) {
        return this.integrationMap.get(soil);
    }
}

