/*
 * Decompiled with CFR 0.152.
 */
package org.dave.bonsaitrees.compat.CraftTweaker2.handlers;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import java.util.Locale;
import org.dave.bonsaitrees.compat.CraftTweaker2.registries.TagModificationsRegistry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.bonsaitrees.SoilCompatibility")
public class SoilCompatibilityHandler {
    @ZenMethod
    public static void addCompatibleTagToTree(String treeName, String tag) {
        TagModificationAction.apply(0, treeName, tag);
    }

    @ZenMethod
    public static void removeCompatibleTagFromTree(String treeName, String tag) {
        TagModificationAction.apply(1, treeName, tag);
    }

    @ZenMethod
    public static void addProvidedTagToSoil(String soilName, String tag) {
        TagModificationAction.apply(2, soilName, tag);
    }

    @ZenMethod
    public static void removeProvidedTagFromSoil(String soilName, String tag) {
        TagModificationAction.apply(3, soilName, tag);
    }

    private static class TagModificationAction
    implements IAction {
        int action;
        String objName;
        String tag;

        public TagModificationAction(int action, String objName, String tag) {
            this.action = action;
            this.objName = objName;
            this.tag = tag;
        }

        public static void apply(int action, String objName, String tag) {
            CraftTweakerAPI.apply((IAction)new TagModificationAction(action, objName, tag));
        }

        public void apply() {
            if (this.action == 0) {
                TagModificationsRegistry.addCompatibleTagToTree(this.objName, this.tag);
            } else if (this.action == 1) {
                TagModificationsRegistry.removeCompatibleTagFromTree(this.objName, this.tag);
            } else if (this.action == 2) {
                TagModificationsRegistry.addProvidedTagToSoil(this.objName, this.tag);
            } else if (this.action == 3) {
                TagModificationsRegistry.removeProvidedTagFromSoil(this.objName, this.tag);
            }
        }

        public String describe() {
            String verb = this.action == 0 || this.action == 2 ? "Adding" : "Removing";
            String subject = this.action == 0 || this.action == 1 ? "tree" : "soil";
            return String.format(Locale.ENGLISH, "%s tag '%s' to %s '%s'", verb, this.tag, subject, this.objName);
        }
    }
}

