/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.dakimakuramod.common.network.message.server;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import moe.plushie.dakimakuramod.DakimakuraMod;
import moe.plushie.dakimakuramod.common.dakimakura.Daki;
import moe.plushie.dakimakuramod.common.dakimakura.DakiManager;
import moe.plushie.dakimakuramod.common.dakimakura.pack.AbstractDakiPack;
import moe.plushie.dakimakuramod.common.dakimakura.pack.DakiPackFolder;
import moe.plushie.dakimakuramod.common.dakimakura.pack.DakiPackZipFile;
import moe.plushie.dakimakuramod.common.dakimakura.pack.IDakiPack;
import moe.plushie.dakimakuramod.common.dakimakura.serialize.DakiJsonSerializer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageServerSendDakiList
implements IMessage,
IMessageHandler<MessageServerSendDakiList, IMessage> {
    private final DakiManager dakiManager = DakimakuraMod.getProxy().getDakimakuraManager();
    private ArrayList<IDakiPack> packs;

    public void toBytes(ByteBuf buf) {
        ArrayList<IDakiPack> dakiPacks = this.dakiManager.getDakiPacksList();
        DakimakuraMod.getLogger().info("Sending " + dakiPacks.size() + " packs to client.");
        buf.writeInt(dakiPacks.size());
        for (int i = 0; i < dakiPacks.size(); ++i) {
            IDakiPack dakiPack = dakiPacks.get(i);
            buf.writeBoolean(dakiPack instanceof DakiPackFolder);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)dakiPack.getResourceName());
            ArrayList<Daki> dakis = dakiPack.getDakisInPack();
            buf.writeInt(dakis.size());
            for (int j = 0; j < dakis.size(); ++j) {
                Daki daki = dakis.get(j);
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)daki.getDakiDirectoryName());
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)DakiJsonSerializer.serialize(daki).toString());
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.packs = new ArrayList();
        int packCount = buf.readInt();
        DakimakuraMod.getLogger().info("Getting " + packCount + " packs from server.");
        for (int i = 0; i < packCount; ++i) {
            boolean folder = buf.readBoolean();
            String packName = ByteBufUtils.readUTF8String((ByteBuf)buf);
            AbstractDakiPack dakiPack = null;
            dakiPack = folder ? new DakiPackFolder(packName) : new DakiPackZipFile(packName);
            int dakiCount = buf.readInt();
            for (int j = 0; j < dakiCount; ++j) {
                String path = ByteBufUtils.readUTF8String((ByteBuf)buf);
                String dakiJson = ByteBufUtils.readUTF8String((ByteBuf)buf);
                Daki daki = DakiJsonSerializer.deserialize(dakiJson, dakiPack.getResourceName(), path);
                dakiPack.addDaki(daki);
            }
            this.packs.add(dakiPack);
        }
    }

    public IMessage onMessage(MessageServerSendDakiList message, MessageContext ctx) {
        DakimakuraMod.getProxy().setDakiList(message.packs);
        return null;
    }
}

