/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.dakimakuramod.common.dakimakura.pack;

import com.google.common.base.Charsets;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import moe.plushie.dakimakuramod.DakimakuraMod;
import moe.plushie.dakimakuramod.common.dakimakura.Daki;
import moe.plushie.dakimakuramod.common.dakimakura.pack.AbstractDakiPack;
import moe.plushie.dakimakuramod.common.dakimakura.serialize.DakiJsonSerializer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class DakiPackZipFile
extends AbstractDakiPack {
    public DakiPackZipFile(String file) {
        super(file);
    }

    @Override
    public String getName() {
        return this.getResourceName().substring(0, this.getResourceName().length() - 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getResource(String path) {
        byte[] data;
        block6: {
            ZipFile zipFile = null;
            InputStream inputStream = null;
            data = null;
            try {
                zipFile = new ZipFile(new File(this.dakiManager.getPackFolder(), this.getResourceName()), 1);
                ZipEntry zipEntry = zipFile.getEntry(path);
                if (zipEntry != null) {
                    inputStream = zipFile.getInputStream(zipEntry);
                    data = IOUtils.toByteArray((InputStream)inputStream);
                }
                IOUtils.closeQuietly(inputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(zipFile);
            }
            IOUtils.closeQuietly((Closeable)zipFile);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean resourceExists(String path) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(new File(this.dakiManager.getPackFolder(), this.getResourceName()), 1);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                if (!zipEntry.getName().equals(path)) continue;
                boolean bl = true;
                IOUtils.closeQuietly((Closeable)zipFile);
                return bl;
            }
            IOUtils.closeQuietly((Closeable)zipFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(zipFile);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DakiPackZipFile loadPack() {
        DakimakuraMod.getLogger().info("Loading Pack: " + this.getResourceName());
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(new File(this.dakiManager.getPackFolder(), this.getResourceName()), 1);
            int depth = this.findDepth(zipFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                if (!(zipEntry.isDirectory() & this.getDepth(zipEntry.getName()) == depth)) continue;
                this.loadDaki(zipFile, zipEntry);
            }
            IOUtils.closeQuietly((Closeable)zipFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(zipFile);
        }
        return this;
    }

    private int findDepth(ZipFile zipFile) {
        int depth = 0;
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            depth = Math.max(depth, this.getDepth(zipEntry.getName()));
        }
        return depth;
    }

    private int getDepth(String str) {
        return StringUtils.countMatches((CharSequence)str, (CharSequence)"/") - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadDaki(ZipFile zipFile, ZipEntry zipEntry) {
        String dakiName = zipEntry.getName().substring(0, zipEntry.getName().length() - 1);
        String[] split = dakiName.split("/");
        dakiName = split[split.length - 1];
        dakiName = zipEntry.getName().substring(0, zipEntry.getName().length() - 1);
        ZipEntry dakiJsonZipEntry = zipFile.getEntry(zipEntry.getName() + "daki-info.json");
        if (dakiJsonZipEntry != null) {
            InputStream inputStream = null;
            try {
                inputStream = zipFile.getInputStream(dakiJsonZipEntry);
                String dakiJson = IOUtils.toString((InputStream)inputStream, (Charset)Charsets.UTF_8);
                Daki daki = DakiJsonSerializer.deserialize(dakiJson, this.getResourceName(), dakiName);
                if (daki == null) return;
                this.addDaki(daki);
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        } else {
            this.addDaki(new Daki(this.getResourceName(), dakiName));
        }
    }
}

